% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nint.R
\name{nint_space}
\alias{nint_space}
\title{Space}
\usage{
nint_space(...)
}
\arguments{
\item{...}{dimensions each of which may be an actual dimension object or a list structure of dimension objects.}
}
\value{
\code{nint_space} returns an object of \code{class} \code{"nint_space"}.
An object of \code{class} \code{"nint_space"} is an ordered list of dimension objects.
}
\description{
\code{nint_space} defines an n-dimensional space as a list of dimensions.
A space may consist of subspaces.
A space without subspaces is called true subspace.
}
\details{
If a space contains at least one list structure of dimension objects it consists of subspaces.
Each subspace is then defined by a combination of dimension objects along the dimensions.
See \code{\link{nint_expandSpace}} on how to expand a space to true subspaces.
}
\examples{
s = nint_space(nint_gridDim(seq(1, 3, 0.9)),
               nint_scatDim(seq(2, 5, 0.8)),
               nint_intvDim(-Inf, Inf),
               nint_funcDim(function(x) nint_intvDim(0, x[1])),
               list(nint_gridDim(c(0, 10)),
                    list(nint_intvDim(1, 7)))
               )
s
}
\seealso{
\code{\link{nint_scatDim}}, \code{\link{nint_gridDim}}, \code{\link{nint_intvDim}}, \code{\link{nint_funcDim}}, \code{\link{nint_integrate}}, \code{\link{nint_validateSpace}}, \code{\link{nint_expandSpace}}, \code{\link{fisherI}}
}
