% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{dm_validate}
\alias{dm_validate}
\title{Validator}
\usage{
dm_validate(x)
}
\arguments{
\item{x}{An object.}
}
\value{
Returns the \code{dm}, invisibly, after finishing all checks.
}
\description{
\code{dm_validate()} checks the internal consistency of a \code{dm} object.
}
\details{
In theory, with the exception of \code{\link[=new_dm]{new_dm()}}, all \code{dm} objects
created or modified by functions in this package should be valid,
and this function should not be needed.
Please file an issue if any dm operation creates an invalid object.
}
\examples{
dm_validate(dm())

bad_dm <- structure(list(bad = "dm"), class = "dm")
try(dm_validate(bad_dm))
}
