% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/master.R
\name{HEMaster}
\alias{HEMaster}
\title{Create a HEMaster process for use in a distributed homomorphic
encrypted (HE) computation}
\description{
\code{HEMaster} objects run a distributed computation based
upon a definition file that encapsulates all information
necessary to perform a computation. A master makes use of two
non-cooperating parties which communicate with sites that
perform the actual computations using local data.
}
\seealso{
\code{\link[=NCP]{NCP()}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{den}}{denominator for rational arithmetic}

\item{\code{den_bits}}{number of bits for denominator for rational arithmetic}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{HEMaster$new()}}
\item \href{#method-getNC_party}{\code{HEMaster$getNC_party()}}
\item \href{#method-getPubkey}{\code{HEMaster$getPubkey()}}
\item \href{#method-addNCP}{\code{HEMaster$addNCP()}}
\item \href{#method-run}{\code{HEMaster$run()}}
\item \href{#method-clone}{\code{HEMaster$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a \code{HEMaster} object to run homomorphic encrypted computation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEMaster$new(defn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{defn}}{the homomorphic computation definition}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{HEMaster} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNC_party"></a>}}
\subsection{Method \code{getNC_party()}}{
Return a list of noncooperating parties (NCPs)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEMaster$getNC_party()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a named list of length 2 of noncooperating party information
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPubkey"></a>}}
\subsection{Method \code{getPubkey()}}{
Return the public key from the public private key pair
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEMaster$getPubkey()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an R6 \code{Pubkey} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addNCP"></a>}}
\subsection{Method \code{addNCP()}}{
Add a noncooperating party to this master either using a url or an object in session for prototyping
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEMaster$addNCP(ncp_defn, url = NULL, ncpWorker = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ncp_defn}}{the definition of the NCP}

\item{\code{url}}{the url for the NCP; only one of url and ncpWorker should be non-null}

\item{\code{ncpWorker}}{an instantiated worker object; only one of url and ncpWorker should be non-null}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\subsection{Method \code{run()}}{
Run a distributed homomorphic encrypted computation and return the result
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEMaster$run(debug = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{debug}}{a flag for debugging, default \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the result of the distributed homomorphic computation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEMaster$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
