% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distcomp.R
\name{createInstanceObject}
\alias{createInstanceObject}
\title{Given the definition identifier of an object, instantiate and store object in workspace}
\usage{
createInstanceObject(defnId, instanceId, dataFileName = NULL)
}
\arguments{
\item{defnId}{the identifier of an already defined computation}

\item{instanceId}{an indentifier to use for the created instance}

\item{dataFileName}{a file name to use for saving the data. Typically \code{NULL}, this
is only needed when one is using a single opencpu server to behave like multiple
sites in which case the data file name serves to distinguish the site-specific data files.
When it is \code{NULL}, the data file name is taken from the configuration settings}
}
\value{
TRUE if everything goes well
}
\description{
The function \code{createInstanceObject} uses a definition identified by
defnId to create the appropriate object instance. The instantiated object is assigned
the instanceId and saved under the dataFileName if the latter is specified.
This instantiated object may change state between iterations when a computation executes
}
\seealso{
\code{\link{availableComputations}}
}
