% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FTG-density.R
\name{dFTG}
\alias{dFTG}
\title{FTG Density Function}
\usage{
dFTG(x, threshold, scale, shape)
}
\arguments{
\item{x}{Sample data.}

\item{threshold}{Minimum value of the tail.}

\item{scale}{Scale parameter.}

\item{shape}{Shape parameter.}
}
\value{
Gives the density of the FTG. The length of the result is determined by the length of x.
}
\description{
This function computes the density of the full-tail gamma with the input sample data. The expression for the density used is:
\deqn{g(x; \alpha, \theta, \rho) = \theta(\rho + \theta x)^{\alpha - 1}\exp(-(\rho + \theta x))/\Gamma(\alpha, \rho).}
}
\examples{
a <- 0.3
t <- 0.3
r <- 0.8
n <- 1000
sample <- rFTG(n, a, t, r)
x <- seq(min(sample), max(sample), length.out = 200)
d <- dFTG(x, a, t, r)
hist(sample, breaks = "FD", probability = TRUE)
lines(x, d, col = "red")
}
\references{
del Castillo, Joan & Daoudi, Jalila & Serra, Isabel. (2012). The full-tails gamma distribution applied to model extreme values. ASTIN Bulletin. <doi:10.1017/asb.2017.9>.
}
\keyword{FTG}
