% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{year.date_xx}
\alias{year.date_xx}
\alias{month}
\alias{year}
\alias{month.date_xx}
\alias{isoweek.date_xx}
\title{Get Year, Quarter or Month (lubridate Compatibility)}
\usage{
year.date_xx(x)

month.date_xx(x, label = FALSE, abbr = TRUE, locale = Sys.getlocale("LC_TIME"))

isoweek.date_xx(x)
}
\arguments{
\item{x}{a \link{date_xx} or any \R object that can be coerced to \code{POSIXlt}}

\item{label}{logical. TRUE will display the month as a character string such
as "January." FALSE will display the month as a number.}

\item{abbr}{logical. FALSE will display the month as a character string
label, such as "January". TRUE will display an abbreviated version of the
label, such as "Jan". abbr is disregarded if label = FALSE.}

\item{locale}{for month, locale to use for month names. Default to current locale.}
}
\description{
See \code{\link[lubridate:year]{lubridate::year()}} and \code{\link[lubridate:month]{lubridate::month()}}
}
\examples{

\dontrun{
  library(lubridate)
  month(x)
  month(x, label = TRUE)
}

\dontrun{
  library(lubridate)
  isoweek(x)
}
}
\seealso{
\link{get_year}
}
