% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.r
\name{[.date_xx}
\alias{[.date_xx}
\alias{[<-.date_yq}
\alias{[<-.date_ym}
\alias{[<-.date_yw}
\alias{[[.date_xx}
\alias{[[<-.date_yq}
\alias{[[<-.date_ym}
\alias{[[<-.date_yw}
\title{Extract or Replace Elements of a date_xx}
\usage{
\method{[}{date_xx}(x, i)

\method{[}{date_yq}(x, i) <- value

\method{[}{date_ym}(x, i) <- value

\method{[}{date_yw}(x, i) <- value

\method{[[}{date_xx}(x, i)

\method{[[}{date_yq}(x, i) <- value

\method{[[}{date_ym}(x, i) <- value

\method{[[}{date_yw}(x, i) <- value
}
\arguments{
\item{x}{
    object from which to extract element(s) or in which to replace element(s).
  }

\item{i}{
    indices specifying elements to extract or replace.  Indices are
    \code{numeric} or \code{character} vectors or empty (missing) or
    \code{NULL}.  Numeric values are coerced to integer as by
    \code{\link[base]{as.integer}} (and hence truncated towards zero).
    Character vectors will be matched to the \code{\link[base]{names}} of the
    object (or for matrices/arrays, the \code{\link[base]{dimnames}}):
    see \sQuote{Character indices} below for further details.

    For \code{[}-indexing only: \code{i}, \code{j}, \code{\dots} can be
    logical vectors, indicating elements/slices to select.  Such vectors
    are recycled if necessary to match the corresponding extent.
    \code{i}, \code{j}, \code{\dots} can also be negative integers,
    indicating elements/slices to leave out of the selection.

    When indexing arrays by \code{[} a single argument \code{i} can be a
    matrix with as many columns as there are dimensions of \code{x}; the
    result is then a vector with elements corresponding to the sets of
    indices in each row of \code{i}.

    An index value of \code{NULL} is treated as if it were \code{integer(0)}.
  }

\item{value}{A vector of the same class as \code{x} or a vector of integers that
correspond to the internal representation \code{date_yq/date_ym/date_yw} objects
(see examples)}
}
\value{
a \code{date_xx} vector
}
\description{
Works exactly like subsetting base vectors via \code{[}, but preserves the
\code{date_xx} class and subclasses. The replacement functions \verb{[<-} and \verb{[[<-}
conduct additional checks before assignment to prevent the generation of
degenerate date_xx vectors (see examples).
}
\examples{
x <- date_yq(2016, 1:4)

x[[2]]
x[1] <- date_yq(2016, 3)
x[2] <- 20164  # 2016, 4th quarter
x[1:2]

# Trying to assign illegal values for the respective date_xx type raises an error
try(x[2] <- 20165)

x <- date_ym(2016, 1:3)
x[1] <- 201610  # October 2016

x <- date_yw(2016, 50:52)
x[1] <- 201649  # 2016, week 52


}
\seealso{
\link[base:Extract]{base::Extract}
}
