% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimNLR.R
\name{estimNLR}
\alias{estimNLR}
\title{Non-Linear Regression DIF models estimation.}
\usage{
estimNLR(y, match, group, formula, method, lower, upper, start)
}
\arguments{
\item{y}{numeric: binary vector of responses.}

\item{match}{numeric: vector of matching criterion.}

\item{group}{numeric: binary vector of group membership. \code{"0"} for reference group, \code{"1"} for focal group.}

\item{formula}{formula: specification of the model. Can be obtained by \code{formulaNLR()} function.}

\item{method}{character: method used to estimate parameters. The options are \code{"nls"} for non-linear least
squares (default) and \code{"likelihood"} for maximum likelihood method.}

\item{lower}{numeric: lower bounds for parameters of model specified in \code{formula}.}

\item{upper}{numeric: upper bounds for parameters of model specified in \code{formula}.}

\item{start}{numeric: initial parameters. Can be obtained by \code{startNLR()} function.}
}
\description{
Estimates parameters of non-linear regression models for DIF detection using either
non-linear least squares or maximum likelihood method.
}
\examples{
data(GMAT)

# item 1
y <- GMAT[, 1]
match <- scale(rowSums(GMAT[, 1:20]))
group <- GMAT[, "group"]

# formula for 3PL model with the same guessing
M <- formulaNLR(model = "3PLcg", type = "both")

# starting values for 3PL model with the same guessing for item 1
start <- startNLR(GMAT[, 1:20], group, model = "3PLcg", parameterization = "classic")
start <- start[[1]][M$M0$parameters]

# Non-linear least squares
fitNLSM0 <- estimNLR(
  y = y, match = match, group = group,
  formula = M$M0$formula, method = "nls",
  lower = M$M0$lower, upper = M$M0$upper, start = start
)
fitNLSM0

coef(fitNLSM0)
logLik(fitNLSM0)
vcov(fitNLSM0)
vcov(fitNLSM0, sandwich = TRUE)
fitted(fitNLSM0)
residuals(fitNLSM0)

# Maximum likelihood
fitLKLM0 <- estimNLR(
  y = y, match = match, group = group,
  formula = M$M0$formula, method = "likelihood",
  lower = M$M0$lower, upper = M$M0$upper, start = start
)
fitLKLM0

coef(fitLKLM0)
logLik(fitLKLM0)
vcov(fitLKLM0)
fitted(fitLKLM0)
residuals(fitLKLM0)
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
\keyword{DIF}
