% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dggridR.R
\name{dgearthgrid}
\alias{dgearthgrid}
\title{Return the coordinates constituting the boundary of cells for the
         entire Earth}
\usage{
dgearthgrid(dggs, frame = TRUE, wrapcells = TRUE, savegrid = FALSE)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct()}

\item{frame}{If TRUE, return a data frame suitable for ggplot plotting.
If FALSE, return an OGR poly object}

\item{wrapcells}{Cells which cross -180/180 degrees can present 
difficulties for plotting. Setting this TRUE will result in
cells with components in both hemispheres to be mapped
entirely to positive degrees (the Eastern hemisphere). As a
result, such cells will have components in the range
[180,360). Only used when \code{frame=TRUE}.}

\item{savegrid}{If savegrid is true then a KML representation of the grid is
produced and the filename returned. No other manipulations
are done. Setting this true overrides all other arguments.}
}
\value{
Returns a data frame or OGR poly object, as specified by \code{frame}.
        If \code{savegrid=TRUE}, returns a filename.
}
\description{
Note: If you have a high-resolution grid this may take a
                 loooooong time to execute.
}
\examples{
library(dggridR)
dggs <- dgconstruct(res=20)
res  <- dg_closest_res_to_spacing(dggs,spacing=1000,round='down',metric=FALSE)
dggs <- dgsetres(dggs,res)
gridfilename <- dgearthgrid(dggs,savegrid=TRUE) #Save directly to a file

}

