% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.dfrr.R
\name{fitted.dfrr}
\alias{fitted.dfrr}
\title{Obtain fitted curves for a dfrr model}
\usage{
\method{fitted}{dfrr}(
  object,
  return.fourier.coefs = NULL,
  return.evaluations = !return.fourier.coefs,
  time_to_evaluate = NULL,
  standardized = NULL,
  unstandardized = !standardized,
  ...
)
}
\arguments{
\item{object}{a fitted \code{dfrr}-object obtained from invoking the function \code{\link{dfrr}}.}

\item{return.fourier.coefs, return.evaluations}{a \code{boolean} indicating whether the Fourier coefficients of the fitted curves are returned
(\code{return.fourier.coefs=TRUE}), or evaluations of the fitted curves (\code{return.evaluations=TRUE}).
Defaults to \code{return.fourier.coefs=TRUE}.}

\item{time_to_evaluate}{a numeric vector indicating the set of time points for evaluating the fitted latent functions, for the case of \code{return.evaluations=TRUE}.}

\item{standardized, unstandardized}{a \code{boolean} indicating whether stanadrdized/unstandardized fitted latent curves is reported.
Only standardized fitted curves are identifiable, thus the arugment is defaults to \code{standardized=TRUE}.}

\item{...}{dot argument, just for consistency with the generic function}
}
\value{
This function returns a \code{matrix} of dimension NxM or NxJ, depending
the argument \code{return.evaluations}. If \code{return.evaluations=FALSE},
the returned matrix is NxJ, where N denotes the sample size (the number of rows of the argument 'newData'),
and J denotes the number of basis functions. Then, the NxJ matrix is
the fourier coefficients of the fitted curves.
If \code{return.evaluations=TRUE},
the returned matrix is NxM, where M is the length of the argument \code{time_to_evaluate}.
Then, the NxM matrix is the fitted curves
 evaluated at time points given in \code{time_to_evaluate}.
}
\description{
Fitted curves refer to the estimations of latent functional response curves.
The results can be either the Fourier coefficients or evaluation of the
fitted functions. See Details.
}
\details{
This function will return either the Fourier coefficients or the evaluation of
fitted curves to the binary sequences. Fourier coefficients which are reported are
based on the a set of basis which can be determined by \code{\link{basis}(dfrr_fit)}.
Thus the evaluation of fitted latent curves on the set of time points specified by vector \code{time},
equals to \code{fitted(dfrr_fit)\%*\%t(\link[fda]{eval.basis}(time,\link{basis}(dfrr_fit)))}.

Consider that the unstandardized estimations are not identifiable. So, it is recommended to
extract and report the standardized estimations.
}
\examples{
set.seed(2000)
\donttest{N<-50;M<-24}
\dontshow{N<-30;M<-12}
X<-rnorm(N,mean=0)
time<-seq(0,1,length.out=M)
Y<-simulate_simple_dfrr(beta0=function(t){cos(pi*t+pi)},
                        beta1=function(t){2*t},
                        X=X,time=time)

#The argument T_E indicates the number of EM algorithm.
#T_E is set to 1 for the demonstration purpose only.
#Remove this argument for the purpose of converging the EM algorithm.
dfrr_fit<-dfrr(Y~X,yind=time,T_E=1)
fitteds<-fitted(dfrr_fit)
plot(fitteds)

}
\seealso{
\code{\link{plot.fitted.dfrr}}
}
