\name{CombPlateau_next}
\alias{CombPlateau_next}
\alias{print.CombPlateau_next}
\title{Combination determination for the combination of two agents where toxicity is increasing with the dose of both agent and efficacy is increasing and possibly plateaus with the dose of one agent}
\description{
\code{CombPlateau_next} is used to determine the next or recommended combination in a phase I/II clinical trial for combination studies where the toxicity is assumed to increase with the dose of both agents, and the efficacy is asummed to increase with one agent and increase and possibily plateaus with the second agent. This phase I/II adaptive design is performed using the design proposed by Riviere et al. entitled "A Bayesian dose finding design for clinical trials combining a cytotoxic agent with a molecularly targeted agent".
}
\usage{
CombPlateau_next(ndose_a1, ndose_a2, tox_max, eff_min, prior_tox_a1, 
prior_tox_a2, prior_eff_a1, prior_eff_a2, stage, in_startup, cohort_start=3, 
cohort, pat_incl, dose_adm1, dose_adm2, toxicity, time_full, time_prog, 
time_follow, cycle=0, c_tox=0.85, c_eff=0.10)
}
\arguments{ 
  \item{ndose_a1}{Number of dose levels for agent 1.}
  \item{ndose_a2}{Number of dose levels for agent 2.}
  \item{tox_max}{Maximum acceptable toxicity probability.}
  \item{eff_min}{Minimum efficacy probability desired.}
  \item{prior_tox_a1}{A vector of initial guesses of toxicity probabilities associated with the doses of agent 1. Must be of length \code{ndose_a1}.}
  \item{prior_tox_a2}{A vector of initial guesses of toxicity probabilities associated with the doses of agent 2. Must be of length \code{ndose_a2}.}
  \item{prior_eff_a1}{A vector of initial guesses of efficacy probabilities associated with the doses of agent 1. Must be of length \code{ndose_a1}.}
  \item{prior_eff_a2}{A vector of initial guesses of efficacy probabilities associated with the doses of agent 2. Must be of length \code{ndose_a2}.}
  \item{stage}{A integer with value 0 if less than half of the total sample size have been included, 1 if more than half of the total sample size have been included but the trial is still on-going, and 2 if the trial is over and dose recommendation should be done.}
  \item{in_startup}{TRUE if the start-up was not ended, FALSE otherwise.}
  \item{cohort_start}{Cohort size for the start-up phase. Default is set at 3.}
  \item{cohort}{Cohort size for the model-based phase.}
  \item{pat_incl}{Current number of patients included.}
  \item{dose_adm1}{A vector indicating the dose levels of agents 1 administered to each patient included in the trial. Must be of length \code{pat_incl}.}
  \item{dose_adm2}{A vector indicating the dose levels of agents 2 administered to each patient included in the trial. Must be of length \code{pat_incl}.}
  \item{toxicity}{A vector of observed toxicities (DLTs) for each patient included in the trial. Must be of length \code{pat_incl}.}  
  \item{time_full}{Full follow-up time window for efficacy evaluation.}
  \item{time_prog}{A vector of times-to-progression for each patient included in the trial. If no progression (stability or efficacy) was observed for a patient, must be filled with +Inf. Must be of length \code{pat_incl}.}
  \item{time_follow}{A vector of follow-up times for each patient included in the trial. Must be of length \code{pat_incl}.} 
  \item{cycle}{Minimum waiting time between two dose cohorts (usually a toxicity cycle). Default value is set at 0.}
  \item{c_tox}{Toxicity threshold for decision rules. The default value is set at 0.85.}
  \item{c_eff}{Efficacy threshold for decision rules. The default value is set at 0.10.} 
}
\value{
An object of class "CombPlateau_next" is returned, consisting of determination of the next combination and estimations. Objects generated by \code{CombPlateau_next} contain at least the following components: 

\item{n_pat_comb}{Number of patients per combination.}
\item{n_tox_comb}{Number of observed toxicities per combination.}
\item{n_eff_comb}{Number of observed toxicities per combination.}
\item{pi}{Estimated toxicity probabilities (if the start-up ended).}
\item{ptox_sup}{Estimated probabilities that the toxicity probability is superior to \code{tox_max} (if the start-up ended).}
\item{resp}{Estimated efficacy probabilities (if the start-up ended).}
\item{qeff_min}{Estimated probabilities that the efficacy probability is superior to \code{eff_min} (if the start-up ended).}
\item{proba_tau}{Estimated posterior probabilities for plateau location at each dose of agent 2 (if the start-up ended).}
\item{startup_in}{Start-up phase is ended or not.}
\item{(cdose1, cdose2)}{NEXT RECOMMENDED COMBINATION.}
\item{cohort}{Cohort size.}
\item{pat_incl}{Number of patients included.}
\item{tox_max}{Toxicity upper bound.}
\item{eff_min}{Efficacy lower bound.}
\item{prior_tox_a1}{Prior toxicity probabilities for agent 1.}
\item{prior_tox_a2}{Prior toxicity probabilities for agent 2.}
\item{prior_eff_a1}{Prior efficacy probabilities for agent 1.}
\item{prior_eff_a2}{Prior efficacy probabilities for agent 2.}
\item{c_tox}{Tocixity threshold.}
\item{c_eff}{Efficacy threshold.}
\item{time_full}{Full follow-up time for efficacy is also reminded.}
}
\references{
Riviere, M-K., Yuan, Y., Dubois, F., and Zohar, S. (2015). A Bayesian dose finding design for clinical trials combining a cytotoxic agent with a molecularly targeted agent. Journal of the Royal Statistical Society - Series C.
}
\author{Jacques-Henri Jourdan and Marie-Karelle Riviere-Jourdan \email{eldamjh@gmail.com}}
\seealso{
  \code{\link{CombPlateau_sim}}.
}
\examples{
prior_tox_a1 = c(0.2, 0.3, 0.4)
prior_eff_a1 = c(0.3, 0.4, 0.5)
prior_tox_a2 = c(0.12, 0.2, 0.3, 0.4)
prior_eff_a2 = c(0.3, 0.4, 0.5, 0.59)
toxicity = c(0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0)
dose1 = c(1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,2,2,2)
dose2 = c(1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2)
t_prog = c(1.6,4.2,3.5,5.1,2.4,4.8,2.8,4.4,+Inf,3.9,+Inf,4.6,1.8,+Inf,0.5,5.4,2.8,+Inf)
follow = c(rep(7,15), 4.9, 3.1, 1.3)

next1 = CombPlateau_next(ndose_a1=3, ndose_a2=4, tox_max=0.30, eff_min=0.20, 
prior_tox_a1, prior_tox_a2, prior_eff_a1, prior_eff_a2, stage=0, in_startup=FALSE,
cohort=3, pat_incl=18, dose_adm1=dose1, dose_adm2=dose2, toxicity=toxicity, 
time_full=7, time_prog=t_prog, time_follow=follow)

next1
}
