% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{adjWeibull}
\alias{adjWeibull}
\title{Adjust (fit) three-parameter Weibull distribution}
\usage{
adjWeibull(x, amplitude = 10, shape = 2, plot = TRUE, main = NULL,
title.col = "black", mid = TRUE, line.col = "blue", legendPos = "topright",
lowLim = NULL, ymax = NULL, bg = "aliceblue", method = "mps", cex.axis = 0.6,
cex.lab = 0.8, las = 1, xlab = "Diameter class (cm)",
ylab = "Relative frequency (\%)", ...)
}
\arguments{
\item{x}{numeric, vector of observations.}

\item{amplitude}{numeric, amplitude of classes.}

\item{shape}{numeric, optional initial values of shape for starting the
iterative procedures such as Newton-Raphson.}

\item{plot}{logical. Should plot?}

\item{main}{character, overall title for the plot.}

\item{title.col, line.col}{the color to be used for the overall title and
the plot line plot respectively. Default are "blue" and "black".}

\item{mid}{logical. Should the line stop at the first and last classes middle?}

\item{legendPos}{character, keyword which is accepted by
\code{\link[grDevices]{xy.coords}}. To be used to position the legend.
Default is "topright".}

\item{lowLim, ymax}{numeric, xlim and ylim lowest values.}

\item{bg}{the color to be used for the background of the legend box.}

\item{method}{used method for estimating the three-parameter Weibull
distribution. See \code{\link[ForestFit]{fitWeibull}} for details.}

\item{cex.axis, cex.lab, las}{graphical parameters.
See \code{\link[graphics]{par}}.}

\item{xlab, ylab}{title for the x and y axis.}

\item{...}{additional arguments to pass through \code{\link[base]{plot}}.}
}
\description{
Adjust (fit) three-parameter Weibull distribution
}
\examples{
set.seed(2)
d <- rweibull(85, shape = 1, scale = 30) + 5
res <- adjWeibull(d,
  amplitude = 10, mid = FALSE, shape = 3, ymax = 30,
  main = "Weibull adjustment", line.col = "red", legendPos = "right",
  method = "mps"
)
res
}
