% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleSimFit.R
\name{Impute}
\alias{Impute}
\title{Produce imputed data sets}
\usage{
Impute(fit, impute.mechanism, N)
}
\arguments{
\item{fit}{A \code{SingleSimFit} object}

\item{impute.mechanism}{An \code{ImputeMechanism} object}

\item{N}{The number of data sets to impute}
}
\value{
An \code{ImputeSim} object
}
\description{
Given a \code{SingleSimFit} object (with impute.parameters not NULL)
and an imputation mechanism,
create a collection of imputed data sets
}
\examples{
sim <- SimulateComplete(study.time=365,number.subjects=50,
    event.rates=c(0.01,0.005),dispersions=0.25)
sim.with.MCAR.dropout <- SimulateDropout(sim,
    drop.mechanism = ConstantRateDrop(rate = 0.0025))
fit <- Simfit(sim.with.MCAR.dropout)
imps <- Impute(fit, copy_reference(), 10)

}
