% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddml_fpliv.R
\name{ddml_fpliv}
\alias{ddml_fpliv}
\title{Estimator for the Flexible Partially Linear IV Model.}
\usage{
ddml_fpliv(
  y,
  D,
  Z,
  X,
  learners,
  learners_DXZ = learners,
  learners_DX = learners,
  sample_folds = 10,
  ensemble_type = "nnls",
  shortstack = FALSE,
  cv_folds = 10,
  enforce_LIE = TRUE,
  custom_ensemble_weights = NULL,
  custom_ensemble_weights_DXZ = custom_ensemble_weights,
  custom_ensemble_weights_DX = custom_ensemble_weights,
  cluster_variable = seq_along(y),
  subsamples = NULL,
  cv_subsamples_list = NULL,
  silent = FALSE
)
}
\arguments{
\item{y}{The outcome variable.}

\item{D}{A matrix of endogenous variables.}

\item{Z}{A (sparse) matrix of instruments.}

\item{X}{A (sparse) matrix of control variables.}

\item{learners}{May take one of two forms, depending on whether a single
learner or stacking with multiple learners is used for estimation of the
conditional expectation functions.
If a single learner is used, \code{learners} is a list with two named
elements:
\itemize{
\item{\code{what} The base learner function. The function must be
such that it predicts a named input \code{y} using a named input
\code{X}.}
\item{\code{args} Optional arguments to be passed to \code{what}.}
}
If stacking with multiple learners is used, \code{learners} is a list of
lists, each containing four named elements:
\itemize{
\item{\code{fun} The base learner function. The function must be
such that it predicts a named input \code{y} using a named input
\code{X}.}
\item{\code{args} Optional arguments to be passed to \code{fun}.}
\item{\code{assign_X} An optional vector of column indices
corresponding to control variables in \code{X} that are passed to
the base learner.}
\item{\code{assign_Z} An optional vector of column indices
corresponding to instruments in \code{Z} that are passed to the
base learner.}
}
Omission of the \code{args} element results in default arguments being
used in \code{fun}. Omission of \code{assign_X} (and/or \code{assign_Z})
results in inclusion of all variables in \code{X} (and/or \code{Z}).}

\item{learners_DXZ, learners_DX}{Optional arguments to allow for different
estimators of \eqn{E[D \vert X, Z]}, \eqn{E[D \vert X]}. Setup is
identical to \code{learners}.}

\item{sample_folds}{Number of cross-fitting folds.}

\item{ensemble_type}{Ensemble method to combine base learners into final
estimate of the conditional expectation functions. Possible values are:
\itemize{
\item{\code{"nnls"} Non-negative least squares.}
\item{\code{"nnls1"} Non-negative least squares with the constraint
that all weights sum to one.}
\item{\code{"singlebest"} Select base learner with minimum MSPE.}
\item{\code{"ols"} Ordinary least squares.}
\item{\code{"average"} Simple average over base learners.}
}
Multiple ensemble types may be passed as a vector of strings.}

\item{shortstack}{Boolean to use short-stacking.}

\item{cv_folds}{Number of folds used for cross-validation in ensemble
construction.}

\item{enforce_LIE}{Indicator equal to 1 if the law of iterated expectations
is enforced in the first stage.}

\item{custom_ensemble_weights}{A numerical matrix with user-specified
ensemble weights. Each column corresponds to a custom ensemble
specification, each row corresponds to a base learner in \code{learners}
(in chronological order). Optional column names are used to name the
estimation results corresponding the custom ensemble specification.}

\item{custom_ensemble_weights_DXZ, custom_ensemble_weights_DX}{Optional
arguments to allow for different
custom ensemble weights for \code{learners_DXZ},\code{learners_DX}. Setup
is identical to \code{custom_ensemble_weights}. Note:
\code{custom_ensemble_weights} and
\code{custom_ensemble_weights_DXZ},\code{custom_ensemble_weights_DX} must
have the same number of columns.}

\item{cluster_variable}{A vector of cluster indices.}

\item{subsamples}{List of vectors with sample indices for cross-fitting.}

\item{cv_subsamples_list}{List of lists, each corresponding to a subsample
containing vectors with subsample indices for cross-validation.}

\item{silent}{Boolean to silence estimation updates.}
}
\value{
\code{ddml_fpliv} returns an object of S3 class
\code{ddml_fpliv}. An object of class \code{ddml_fpliv} is a list
containing the following components:
\describe{
\item{\code{coef}}{A vector with the \eqn{\theta_0} estimates.}
\item{\code{weights}}{A list of matrices, providing the weight
assigned to each base learner (in chronological order) by the
ensemble procedure.}
\item{\code{mspe}}{A list of matrices, providing the MSPE of each
base learner (in chronological order) computed by the
cross-validation step in the ensemble construction.}
\item{\code{iv_fit}}{Object of class \code{ivreg} from the IV
regression of \eqn{Y - \hat{E}[Y\vert X]} on
\eqn{D - \hat{E}[D\vert X]} using
\eqn{\hat{E}[D\vert X,Z] - \hat{E}[D\vert X]} as the instrument.}
\item{\code{learners},\code{learners_DX},\code{learners_DXZ},
\code{cluster_variable},\code{subsamples},
\code{cv_subsamples_list},\code{ensemble_type}}{Pass-through of
selected user-provided arguments. See above.}
}
}
\description{
Estimator for the flexible partially linear IV model.
}
\details{
\code{ddml_fpliv} provides a double/debiased machine learning
estimator for the parameter of interest \eqn{\theta_0} in the partially
linear IV model given by

\eqn{Y = \theta_0D + g_0(X) + U,}

where \eqn{(Y, D, X, Z, U)} is a random vector such that
\eqn{E[U\vert X, Z] = 0} and \eqn{E[Var(E[D\vert X, Z]\vert X)] \neq 0},
and \eqn{g_0} is an unknown nuisance function.
}
\examples{
# Construct variables from the included Angrist & Evans (1998) data
y = AE98[, "worked"]
D = AE98[, "morekids"]
Z = AE98[, "samesex", drop = FALSE]
X = AE98[, c("age","agefst","black","hisp","othrace","educ")]

# Estimate the partially linear IV model using a single base learner: Ridge.
fpliv_fit <- ddml_fpliv(y, D, Z, X,
                        learners = list(what = mdl_glmnet,
                                        args = list(alpha = 0)),
                        sample_folds = 2,
                        silent = TRUE)
summary(fpliv_fit)
}
\references{
Ahrens A, Hansen C B, Schaffer M E, Wiemann T (2023). "ddml: Double/debiased
machine learning in Stata." \url{https://arxiv.org/abs/2301.09397}

Chernozhukov V, Chetverikov D, Demirer M, Duflo E, Hansen C B, Newey W,
Robins J (2018). "Double/debiased machine learning for treatment and
structural parameters." The Econometrics Journal, 21(1), C1-C68.

Wolpert D H (1992). "Stacked generalization." Neural Networks, 5(2), 241-259.
}
\seealso{
\code{\link[=summary.ddml_fpliv]{summary.ddml_fpliv()}}, \code{\link[AER:ivreg]{AER::ivreg()}}

Other ddml: 
\code{\link{ddml_ate}()},
\code{\link{ddml_late}()},
\code{\link{ddml_pliv}()},
\code{\link{ddml_plm}()}
}
\concept{ddml}
