% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valesta.r
\name{valesta}
\alias{valesta}
\title{Function to compute prediction statistics based on observed values}
\usage{
valesta(y.obs = y.obs, y.pred = y.pred, want.percent = TRUE)
}
\arguments{
\item{y.obs}{observed values of the variable of interest}

\item{y.pred}{predicted values of the variable of interest}

\item{want.percent}{A logic option for requesting to also
computed the prediction statistics as a percentage of the sample
mean of \code{y.obs}. By default is set to TRUE.}
}
\value{
The main output depends on the \code{want.percent}; if \code{TRUE},
then it has the following six prediction statistics as a vector:
(\code{rmsd}, \code{rmsd.p},\code{ad}, \code{ad.p},  \code{aad}, \code{aad.p}); where
\code{rmsd.p} stands for \code{RMSD} expressed as a percentage, and the
same applies to \code{AD.p} and \code{AAD.p}. Meanwhile,
if \code{want.percent=FALSE}, then it has the following three
prediction statistics as a vector: (\code{rmsd},\code{ad},\code{aad})
}
\description{
Computes three prediction statistics as a way to compare
observed versus predicted values of a response variable
of interest. The statistics are: the root mean square
differences (\eqn{RMSD}), the aggregated difference
(\eqn{AD}), and the absolute aggregated differences (\eqn{AAD}).
All of them are based on
\deqn{r_i = y_i - \widehat{y}_i}
where \eqn{y_i} and \eqn{\widehat{y}_i} are the observed and the
predicted value of the response variable \eqn{y} for
the \eqn{i}-th observation, respectively. Both the observed
and predicted values must be expressed in the same units.
}
\details{
The function computes the three aforementioned statistics expressed
in both (a) the units of the response variable and (b) the percentage.
Notice that to represent each statistic in percentual terms, we divided
them by the mean observed value of the response variable.
}
\examples{

#Creates a fake dataframe
set.seed(1234)
df <- as.data.frame(cbind(Y=rnorm(30, 30,9), X=rnorm(30, 450,133)))
#fitting a candidate model
mod1 <- lm(Y~X, data=df)
#Using the valesta function
valesta(y.obs=df$Y,y.pred=fitted(mod1))
}
\references{
\itemize{
\item Salas C, Ene L, Gregoire TG, Nasset E, Gobakken T. 2010. Modelling tree diameter
from airborne laser scanning derived variables: a comparison of spatial statistical
models. Remote Sensing of Environment 114(6):1277-1285. \doi{10.1016/j.rse.2010.01.020}
\item Salas C. 2002. Ajuste y validación de ecuaciones de volumen para un
relicto del bosque de roble-laurel-lingue.
Bosque 23(2):81–92. \doi{10.4067/S0717-92002002000200009}.
}
}
\author{
Christian Salas-Eljatib.
}
