% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyl_cop_class.R
\docType{class}
\name{cyl_copula-class}
\alias{cyl_copula-class}
\title{An S4 Class of Bivariate Copulas on the Cylinder}
\description{
The class '\code{cyl_copula}' follows somewhat the structure of the class
'\code{\linkS4class{Copula}}' of the package '\pkg{copula}'. It contains
circular-linear copulas.
}
\section{Slots}{

\describe{
\item{\code{name}}{\link[base]{character} string holding the name of the copula.}

\item{\code{parameters}}{\link[base]{numeric} \link[base]{vector} holding the parameter values.}

\item{\code{param.names}}{\link[base]{character} \link[base]{vector} holding the parameter names.}

\item{\code{param.lowbnd}}{\link[base]{numeric} \link[base]{vector} holding the lower bounds of the parameters.}

\item{\code{param.upbnd}}{\link[base]{numeric} \link[base]{vector} holding the upper bounds of the parameters.}
}}

\section{Extended by}{

'\code{cyl_copula}' is extended by the following classes:
\itemize{
\item '\code{\linkS4class{cyl_vonmises}}': von Mises copulas.
\item '\code{\linkS4class{cyl_quadsec}}': Copulas with quadratic sections.
\item '\code{\linkS4class{cyl_cubsec}}': Copulas with cubic sections.
\item '\code{\linkS4class{cyl_rot_combine}}': Linear combinations of copulas and their
180 degree rotations.
\item '\code{\linkS4class{cyl_rect_combine}}': Rectangular patchwork copulas.
}
}

\section{Objects from the Class}{

Objects are created by the functions \code{\link{cyl_vonmises}()},
\code{\link{cyl_quadsec}()}, \code{\link{cyl_cubsec}()}, \code{\link{cyl_rot_combine}()},
and \code{\link{cyl_rect_combine}()}.
}

\examples{
cop <- cyl_quadsec(0.1)
is(cop)

}
\references{
\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
