% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_roc.R
\name{plot_roc}
\alias{plot_roc}
\title{Plot ROC curve from a cutpointr object}
\usage{
plot_roc(x, display_cutpoint = TRUE, ...)
}
\arguments{
\item{x}{A cutpointr object.}

\item{display_cutpoint}{(logical) Whether or not to display the optimal
cutpoint as a dot on the ROC curve.}

\item{...}{Additional arguments (unused).}
}
\description{
Given a \code{cutpointr} object this function plots the ROC curve(s)
per subgroup, if given.
}
\examples{
opt_cut <- cutpointr(suicide, dsi, suicide)
plot_roc(opt_cut, display_cutpoint = FALSE)

opt_cut_2groups <- cutpointr(suicide, dsi, suicide, gender)
plot_roc(opt_cut_2groups, display_cutpoint = TRUE)
}
\seealso{
Other cutpointr plotting functions: \code{\link{plot.cutpointr}},
  \code{\link{plot_cut_boot}},
  \code{\link{plot_cutpointr}},
  \code{\link{plot_metric_boot}},
  \code{\link{plot_metric}},
  \code{\link{plot_precision_recall}},
  \code{\link{plot_sensitivity_specificity}},
  \code{\link{plot_x}}
}
\concept{cutpointr plotting functions}
