% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsyntax_convenience.r
\name{tc_plot_tree}
\alias{tc_plot_tree}
\title{Visualize a dependency tree}
\usage{
tc_plot_tree(
  tc,
  ...,
  annotation = NULL,
  sentence_i = 1,
  doc_id = NULL,
  pdf_file = NULL
)
}
\arguments{
\item{tc}{a tCorpus}

\item{...}{Arguments passed to \code{\link[rsyntax]{plot_tree}}. Most importantly, this is used to select which specific columns to display on the bottom rows.
For instance, tc_plot_tree(tc, token, lemma, POS) shows only these three columns.}

\item{annotation}{Optionally, the name of a column with an rsyntax annotation.}

\item{sentence_i}{By default, plot_tree uses the first sentence (sentence_i = 1) in the data. sentence_i can be changed to select other sentences by position (the i-th unique sentence in the data). Note that sentence_i does not refer to the values in the sentence column (for this use the sentence argument together with doc_id)}

\item{doc_id}{Optionally, the document id can be specified. If so, sentence_i refers to the i-th sentence within the given document.}

\item{pdf_file}{Directly save the plot as a pdf file}
}
\value{
plots a dependency tree.
}
\description{
A wrapper for the \code{\link[rsyntax]{plot_tree}} function, that can be used directly on a tCorpus.
}
\examples{
if (interactive()) 
  tc_plot_tree(tc_sotu_udpipe, token, lemma, POS)
}
