% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLP.R
\name{makeLP}
\alias{makeLP}
\title{Make a linear production programming problem}
\usage{
makeLP(c, A, b)
}
\arguments{
\item{c}{vector of benefits.}

\item{A}{production matrix.}

\item{b}{vector of resources.}
}
\value{
\code{makeLP} returns a \code{lpSolve} linear program model object. 
Specifically an R external pointer with class \code{lpExtPtr}.
}
\description{
Given a linear production problem \code{A \%*\% x <= b}, the
\code{makeLP} function creates a new \code{lpSolve} linear program model object.
}
\examples{
# Vector of benefits
c <- c(68,52)
# Production matrix
A <- matrix(c(4, 5, 6, 2), ncol = 2, byrow = TRUE)
# Vector of resources
b <- c(4,33)
# Make the associated linear production problem 
prod <- makeLP(c, A, b)
  
}
\author{
D. Prieto
}
