% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestrallineages.R
\name{ancestrallineages}
\alias{ancestrallineages}
\title{Extracts lineages leading to two tips, t1 and t2, from their most recent common ancestor.}
\usage{
ancestrallineages(phyl, phendata, t1, t2)
}
\arguments{
\item{phyl}{The phylogeny of interest in phylo format}

\item{phendata}{Phenotypic data for all tips}

\item{t1}{The first tip of interest}

\item{t2}{The second tip of interest}
}
\value{
A list containing two matrices.  Each matrix corresponds to a tip.  The matrix 
consists of reconstructed ancestral values for all nodes leading from the mrca of both
tips to the tip.
}
\description{
Extracts lineages leading to two tips, t1 and t2, from their most recent common ancestor.
}
\details{
None
}
\examples{

phyl<-rtree(10)
phendata<-fastBM(phyl,nsim=2)
answer<-ancestrallineages(phyl,phendata,"t1","t2")
}
\references{
Paradis, E., J. Claude, and K. Strimmer (2004) APE: Analyses of phylogenetics
and evolution in R langauge. Bioinformatics, 20, 289-290.

Revell, L. J. (2012) phytools: An R package for phylogenetic comparative 
biology (and other things). Methods Ecol. Evol. 3 217-223.

Stayton, C.T.  (2015).  The definition, recognition, and interpretation of
convergent evolution, and two new measure for quantifying and assessing the 
significance of convergence.  Evolution 69:2140-2153.
}
