% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allmaxdist.R
\name{allmaxdist}
\alias{allmaxdist}
\title{Calculates maxdist for all pairs of taxa in a phylogeny.}
\usage{
allmaxdist(phyl, phendata, mat = TRUE)
}
\arguments{
\item{phyl}{The phylogeny of interest in phylo format}

\item{phendata}{Phenotypic data for all tips}

\item{mat}{Whether or not to export the values in a matrix (default) or a list}
}
\value{
A matrix or list of all maxdist values for all pairs of taxa in the phylogeny.
}
\description{
allmaxdist Uses maxdist to calcualte the maximum phenotypic.  distance between the ancestors of all pairs of taxa in a phylogeny.  By default outputs these as a matrix, but can also output a list.  Can take some time to run for large trees.
}
\details{
Regarding the output:  the matrix is better organized, but the list avoids all the zeroes and is probably better for making histograms.
}
\examples{

phyl<-rtree(10)
phendata<-fastBM(phyl,nsim=2)
answer<-allmaxdist(phyl,phendata,mat=TRUE)
}
\references{
Paradis, E., J. Claude, and K. Strimmer (2004) APE: Analyses of phylogenetics
and evolution in R langauge. Bioinformatics, 20, 289-290.

Revell, L. J. (2012) phytools: An R package for phylogenetic comparative 
biology (and other things). Methods Ecol. Evol. 3 217-223.
}
