% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald_CI_diff_CC_paired_2x2.R
\name{Wald_CI_diff_CC_paired_2x2}
\alias{Wald_CI_diff_CC_paired_2x2}
\title{The Wald confidence interval for the difference between paired probabilities}
\usage{
Wald_CI_diff_CC_paired_2x2(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing lower, upper and point estimates of the statistic
}
\description{
The Wald confidence interval for the difference between paired probabilities

with continuity correction

Described in Chapter 8 "The Paired 2x2 Table"
}
\examples{
# Airway hyper-responsiveness before and after stem cell transplantation
# (Bentur et al., 2009)
n <- rbind(c(1, 1), c(7, 12))
Wald_CI_diff_CC_paired_2x2(n)

# Complete response before and after consolidation therapy
# (Cavo et al., 2012)
n <- rbind(c(59, 6), c(16, 80))
Wald_CI_diff_CC_paired_2x2(n)
}
