% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conos.R
\name{stableTreeClusters}
\alias{stableTreeClusters}
\title{Determine number of detectable clusters given a reference walktrap and a bunch of permuted walktraps}
\usage{
stableTreeClusters(
  refwt,
  tests,
  min.threshold = 0.8,
  min.size = 10,
  n.cores = 30,
  average.thresholds = FALSE
)
}
\arguments{
\item{refwt}{reference walktrap result}

\item{tests}{a list of permuted walktrap results}

\item{min.threshold}{numeric Min detectability threshold (default=0.8)}

\item{min.size}{numeric Minimum cluster size (number of leafs) (default=10)}

\item{n.cores}{numeric Number of cores (default=30)}

\item{average.thresholds}{boolean Report a single number of detectable clusters for averaged detected thresholds (default=FALSE) (a list of detected clusters for each element of the tests list is returned by default)}
}
\value{
number of detectable stable clusters
}
\description{
Determine number of detectable clusters given a reference walktrap and a bunch of permuted walktraps
}
