% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conos.R
\name{greedyModularityCut}
\alias{greedyModularityCut}
\title{Performs a greedy top-down selective cut to optmize modularity}
\usage{
greedyModularityCut(
  wt,
  N,
  leaf.labels = NULL,
  minsize = 0,
  minbreadth = 0,
  flat.cut = TRUE
)
}
\arguments{
\item{wt}{walktrap result}

\item{N}{numeric Number of top greedy splits to take}

\item{leaf.labels}{leaf sample label factor, for breadth calculations - must be a named factor containing all wt$names, or if wt$names is null, a factor listing cells in the same order as wt leafs (default=NULL)}

\item{minsize}{numeric Minimum size of the branch (in number of leafs) (default=0)}

\item{minbreadth}{numeric Minimum allowed breadth of a branch (measured as normalized entropy) (default=0)}

\item{flat.cut}{boolean Whether to simply take a flat cut (i.e. follow provided tree; default=TRUE). Does no observe minsize/minbreadth restrictions}
}
\value{
list(hclust - hclust structure of the derived tree, leafContent - binary matrix with rows corresponding to old leaves, columns to new ones, deltaM - modularity increments)
}
\description{
Performs a greedy top-down selective cut to optmize modularity
}
