% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotxc.R
\name{plotxc.pcp}
\alias{plotxc.full}
\alias{plotxc.pcp}
\title{Condition selector plot}
\usage{
plotxc.pcp(Xc, Xc.cond, select.colour = NULL, select.lwd = 3,
  cex.axis = NULL, cex.lab = NULL, tck = NULL, select.cex = 1, ...)

plotxc.full(Xc, Xc.cond, select.colour = NULL, select.lwd = 3,
  cex.axis = NULL, cex.lab = NULL, tck = NULL, select.cex = 0.6, ...)
}
\arguments{
\item{Xc}{A dataframe.}

\item{Xc.cond}{A dataframe with one row and same names as \code{Xc}.}

\item{select.colour}{Colour to highlight \code{Xc.cond}}

\item{select.lwd}{Line weight to highlight \code{Xc.cond}}

\item{cex.axis}{Axis text scaling}

\item{cex.lab}{Label text scaling}

\item{tck}{Plot axis tick size}

\item{select.cex}{Plot symbol size}

\item{...}{not used.}
}
\value{
Produces a plot, and returns a list containing the relevant
  information to update the plot at a later stage.
}
\description{
Multivariate data visualisations used to select sections for
  \code{\link{ceplot}}. Basically visualises a dataset and highlights a
  single point.
}
\seealso{
\code{\link{ceplot}},  \code{\link{plotxs}}, \code{\link{plotxc}}
}

