% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotxc.R
\name{plotxc}
\alias{plotxc}
\title{Condition selector plot}
\usage{
plotxc(xc, xc.cond, name = NULL, trim = NULL, select.colour = NULL,
  select.lwd = NULL, cex.axis = NULL, cex.lab = NULL, tck = NULL,
  select.cex = 1, hist2d = NULL, fullbin = NULL, ...)
}
\arguments{
\item{xc}{A numeric or factor vector, or a dataframe with two columns}

\item{xc.cond}{Same type as \code{xc}, representing a single point in data
space to highlight.}

\item{name}{The variable name for \code{xc}}

\item{trim}{Logical; if \code{TRUE}, long tails of continuous data are
chopped off at the 5th and 95th percentiles.}

\item{select.colour}{Colour to highlight \code{xc.cond}}

\item{select.lwd}{Line weight to highlight \code{xc.cond}}

\item{cex.axis}{Axis text scaling}

\item{cex.lab}{Label text scaling}

\item{tck}{Plot axis tick size}

\item{select.cex}{Plot symbol size}

\item{hist2d}{If \code{TRUE}, a scatterplot is visualised as a 2-D histogram.
Default behaviour is to use a 2-D histogram if there are over 2,000
observations.}

\item{fullbin}{A cap on the counts in a bin for the 2-D histogram, helpful
with skewed data. Larger values give more detail about data density.
Defaults to 25.}

\item{...}{Passed to \code{condvis:::spineplot2}.}
}
\value{
Produces a plot, and returns a list containing the relevant
  information to update the plot at a later stage.
}
\description{
Data visualisations used to select sections for
  \code{\link{ceplot}}.
}
\examples{
## Histogram, highlighting the first case.

data(mtcars)
obj <- plotxc(mtcars[, "mpg"], mtcars[1, "mpg"])
obj$usr

## Barplot, highlighting 'cyl' = 6.

plotxc(as.factor(mtcars[, "cyl"]), 6, select.colour = "blue")

## Scatterplot, highlighting case 25.

plotxc(mtcars[, c("qsec", "wt")], mtcars[25, c("qsec", "wt")],
  select.colour = "blue", select.lwd = 1, lty = 3)

## Boxplot, where 'xc' contains one factor, and one numeric.

mtcars$carb <- as.factor(mtcars$carb)
plotxc(mtcars[, c("carb", "wt")], mtcars[25, c("carb", "wt")],
  select.colour = "red", select.lwd = 3)

## Spineplot, where 'xc' contains two factors.

mtcars$gear <- as.factor(mtcars$gear)
mtcars$cyl <- as.factor(mtcars$cyl)
plotxc(mtcars[, c("cyl", "gear")], mtcars[25, c("cyl", "gear")],
  select.colour = "red")

## Effect of 'trim'.

x <- c(-200, runif(400), 200)
plotxc(x, 0.5, trim = FALSE, select.colour = "red")
plotxc(x, 0.5, trim = TRUE, select.colour = "red")

}
\seealso{
\code{\link{ceplot}},  \code{\link{plotxs}}.

\code{\link{plotxs}}, \code{\link{ceplot}}, \code{\link{condtour}}
}

