% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequ.R
\name{inequ}
\alias{inequ}
\alias{entropy}
\alias{gini}
\alias{simpson}
\alias{palma}
\alias{grs}
\alias{all_inequ}
\title{Inequality and Diversity Measures}
\usage{
inequ(x, unbiased = FALSE, type = c("entropy", "gini", "simpson", "palma",
 "grs", "all"), na.rm = TRUE)

entropy(x, unbiased = FALSE, na.rm = TRUE)

gini(x, unbiased = FALSE, na.rm = TRUE)

simpson(x, unbiased = FALSE, na.rm = TRUE)

palma(x, na.rm = TRUE)

grs(x, na.rm = TRUE)

all_inequ(x, na.rm = TRUE)
}
\arguments{
\item{x}{a non-negative numeric vector.}

\item{unbiased}{Logical. Argument specifying whether or not a finite sample
correction should be applied. The default is FALSE.}

\item{type}{a character string of the measure to be calculated, defaults to
"entropy".}

\item{na.rm}{a logical vector that indicates whether \code{NA} values should
be excluded or not. If set to \code{FALSE} the computation yields \code{NA}.}
}
\value{
prints the calculated measure
}
\description{
A set of different inequality and diversity measures.
}
\details{
\code{inequ} is a wrapper for the proposed inequality measures
\code{entropy}, \code{gini}, \code{simpson}, \code{palma}, \code{grs},
\code{all}.
If no measure is specified, "entropy" is the default.

\code{entropy} returns the (Shannon) Entropy, \code{gini} is the
Gini coefficient, \code{simpson} is the complement of the
Herfindahl-Hirschmann Index. You can normalize each of these three measures
by setting \code{unbiased = TRUE}

\code{Palma} measures the ratio of inequality (used with income inequality)
of the top 10 percent to the bottom 40 percent. \code{grs} is an alternative
inequality measure (Ginevicius, 2009), \code{all} returns all measures in
a one step procedure.
}
\note{
the non- negative vector might market shares of individual firms/units.
In the latter case the vector should sum up to 1.
}
\examples{
# a vector of market shares
share <- c(0.4, 0.2, 0.25, 0.1, 0.05)
# Calculate the Palma ratio
share_p <- inequ(share, type = "palma")
# Calculate the entropy measure directly
share_ent <- entropy(share, unbiased = TRUE)
# Calculate the group measures
share_inequ <- inequ(share, type = "all")

}
\seealso{
{\code{\link{concstats}}, \code{\link{mstruct}}, \code{\link{comp}}}
}
