% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warming_stripes_plot.R
\name{warming_stripes_plot}
\alias{warming_stripes_plot}
\title{A 'cmsaf' extension for creating warming stripes plots.}
\usage{
warming_stripes_plot(
  variable = NULL,
  infile = NULL,
  selected_number = 1,
  analyze_method = TRUE,
  temp_dir = tempdir(),
  out_dir = getwd(),
  climate_dir = NULL,
  climate_year_start = 1983,
  climate_year_end = 2018,
  start_date = NULL,
  end_date = NULL,
  country_code = "S_A",
  lon_min = NULL,
  lon_max = NULL,
  lat_min = NULL,
  lat_max = NULL,
  outfile_name = NULL,
  output_format = "graphic",
  language = "eng",
  keep_files = TRUE,
  states = FALSE,
  attach = FALSE,
  infile_attach = "auto",
  pointsTF = FALSE,
  lineTF = FALSE,
  title = "",
  verbose = TRUE,
  nc = NULL
)
}
\arguments{
\item{variable}{Name of variable in infile (\code{NULL} or character). If \code{NULL} then the first variable from the infile is taken.}

\item{infile}{Path to NetCDF file (\code{NULL} or character). If \code{NULL} then it needs to be specified in the config file.}

\item{selected_number}{Timesteps of the same selected time range (Warming Stripes Plots, Time Series Plots, Trend Plots)}

\item{analyze_method}{Two analyze methods: mean == FALSE; accumulate == TRUE (logical) (Warming Stripes Plots, Time Series Plots, Trend Plots)}

\item{temp_dir}{Path to temporary working directory (character).}

\item{out_dir}{Path to output directory (character).}

\item{climate_dir}{Path to directory in which climatology is computed or contained (\code{NULL} or character). If \code{NULL} then the temp_dir directory is taken.}

\item{climate_year_start}{Start year of climatology (integer).}

\item{climate_year_end}{End year of climatology (integer).}

\item{start_date}{Start date in format of 'YYYY-MM-DD' (\code{NULL} or character). If \code{NULL} then the first date of the infile is used.}

\item{end_date}{End date in format of 'YYYY-MM-DD' (\code{NULL} or character). If \code{NULL} then the last date of the infile is used.}

\item{country_code}{Either a country code in iso3c format or from the following: 'AFR' for Africa, 'EUR' for Europe, 'TOT' for the total disc,
or 'S_A' for an arbitrary region selection (character). If a country is passed the data from within this country is extracted,
else a rectangular box is visualized. Directly provided latitude and longitude ranges will be ignored in case of 'AFR', 'EUR' or 'TOT'.}

\item{lon_min}{Longitude of lower left corner (\code{NULL} or numeric). If \code{NULL} then the smallest longitude of the infile is used.}

\item{lon_max}{Longitude of upper right left corner (\code{NULL} or numeric). If \code{NULL} then the largest longitude of the infile is used.}

\item{lat_min}{Latitude of lower left corner (\code{NULL} or numeric). If \code{NULL} then the smallest latitude of the infile is used.}

\item{lat_max}{Latitude of upper right corner (\code{NULL} or numeric). If \code{NULL} then the largest latitude of the infile is used.}

\item{outfile_name}{Filename of the PNG or MP4 outfile (\code{NULL} or character).
If \code{NULL} then a name is computed from the current configuration.
Please match the file ending according to the output_format.}

\item{output_format}{Specification of output format (either 'graphic' for PNG or 'animation' for MP4).}

\item{language}{Language used for title, legend, etc. in plots (either 'eng' for English or 'deu' for German).}

\item{keep_files}{A flag indicating whether all files created in the process of obtaining the output file should be kept (logical).
If false, all intermediate results are deleted, otherwise all are kept. Keeping these files could improve performance in further function calls.}

\item{states}{Whether to crop/plot administration level of states (logical).}

\item{attach}{Whether to temporaly merge the infile to an already existing one. (logical).}

\item{infile_attach}{File to attach the infile to. When 'auto', a suitable file will be searched in out_dir.
If attach is false, this will be ignored(character).}

\item{pointsTF}{Show data points (logical).}

\item{lineTF}{Show trend line (logical).}

\item{title}{Set title (character).}

\item{verbose}{Whether to display progress messages (logical).}

\item{nc}{Alternatively to \code{infile} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}
}
\description{
This plotting routine generates graphical output for
the given variable within the given time range and area.
Dependent on the output format a PNG is created.
}
