\name{cmm-package}
\alias{cmm-package}
\alias{cmm}
\docType{package}

\title{
Categorical Marginal Models
}
\description{
A package accompanying the book Marginal Models for Dependent,
Clustered, and Longitudinal Categorical Data by Bergsma, Croon, &
Hagenaars, 2009. It's purpose is fitting and testing of marginal models.
}
\details{
\tabular{ll}{
Package: \tab cmm\cr
Type: \tab Package\cr
Version: \tab 2.0\cr
Date: \tab 2009-04-07\cr
License: \tab GPL (>= 2)\cr
}
The package contains principal functions for analyzing marginal models for categorical data.
All functions are illustrated using examples from the book Marginal Models for Dependent,
Clustered, and Longitudunal Categorical Data (Bergsma, Croon, & Hagenaars, 2009).

The package contains the following functions
 \code{\link{ConstraintMatrix}}
 \code{\link{DesignMatrix}}
 \code{\link{DirectSum}}
 \code{\link{JoinModels}}
 \code{\link{MarginalMatrix}}
 \code{\link{MarginalModelFit}}
 \code{\link{ModelStatistics}}
 \code{\link{SampleStatistics}}
 \code{\link{SpecifyCoefficient}}

The package contains the following data sets
 \code{\link{Antisemitism}}
 \code{\link{BodySatisfaction}}
 \code{\link{ClarenceThomas}}
 \code{\link{DutchConcern}}
 \code{\link{DutchPolitics}}
 \code{\link{ErieCounty}}
 \code{\link{EVS}}
 \code{\link{GSS93}}
 \code{\link{LaborParticipation}}
 \code{\link{MarihuanaAlcohol}}
 \code{\link{NES}}
 \code{\link{NKPS}}
 \code{\link{NKPS2}}
 \code{\link{Smoking}}

Thanks are due to Irena Mikolajun for reporting bugs;

}
\author{
Wicher P. Bergsma
L. Andries van der Ark
Maintainer: Wicher P. Bergsma \email{w.p.bergsma@lse.ac.uk}.
}

\references{
  Bergsma, W. P. (1997).
  \emph{Marginal models for categorical data}.
  Tilburg, The Netherlands: Tilburg University Press.
  \url{http://stats.lse.ac.uk/bergsma/pdf/bergsma_phdthesis.pdf}

  Bergsma, W. P., Croon, M. A., & Hagenaars, J. A. P. (2009).
  Marginal models for dependent, clustered, and longitudunal categorical data.
  Berlin: Springer.

}

\keyword{package}
