% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{CMF.from.model.matrices}
\alias{CMF.from.model.matrices}
\title{Create a CMF model object from fitted matrices}
\usage{
CMF.from.model.matrices(
  A,
  B,
  glob_mean = 0,
  implicit = FALSE,
  precompute = TRUE,
  user_bias = NULL,
  item_bias = NULL,
  lambda = 10,
  scale_lam = FALSE,
  l1_lambda = 0,
  nonneg = FALSE,
  NA_as_zero = FALSE,
  scaling_biasA = NULL,
  scaling_biasB = NULL,
  apply_log_transf = FALSE,
  alpha = 1,
  nthreads = parallel::detectCores()
)
}
\arguments{
\item{A}{The obtained user factors (numeric matrix). Dimension is [k, n_users].}

\item{B}{The obtained item factors (numeric matrix). Dimension is [k, n_items].}

\item{glob_mean}{The obtained global mean, if the model is for explicit feedback
and underwent centering. If passing zero, will assume that the values are not to
be centered.}

\item{implicit}{Whether this is an implicit-feedback model.}

\item{precompute}{Whether to generate pre-computed matrices which can help to speed
up computations on new data (see \link{fit_models} for more details).}

\item{user_bias}{The obtained user biases (numeric vector).
If passing `NULL`, will assume that the model did not include user biases.
Dimension is [n_users].}

\item{item_bias}{The obtained item biases (numeric vector).
If passing `NULL`, will assume that the model did not include item biases.
Dimension is [n_item].}

\item{lambda}{Regularization parameter for the L2 norm of the model matrices
(see \link{fit_models} for more details). Can pass different parameters for each.}

\item{scale_lam}{In the explicit-feedback models, whether to scale the regularization
parameter according to the number of entries. This should always be assumed `TRUE`
for models that are fit through stochastic procedures.}

\item{l1_lambda}{Regularization parameter for the L1 norm of the model matrices.
Same format as for `lambda`.}

\item{nonneg}{Whether the model matrices should be constrained to be non-negative.}

\item{NA_as_zero}{When passing sparse matrices, whether to take missing entries as
zero (counting them towards the optimization objective), or to ignore them.}

\item{scaling_biasA}{If passing it, will assume that the model uses the option
`scale_bias_const=TRUE`, and will use this number as scaling
for the regularization of the user biases.}

\item{scaling_biasB}{If passing it, will assume that the model uses the option
`scale_bias_const=TRUE`, and will use this number as scaling
for the regularization of the item biases.}

\item{apply_log_transf}{If passing `implicit=TRUE`, whether to apply a logarithm
transformation on the values of `X`.}

\item{alpha}{If passing `implicit=TRUE`, multiplier to apply to the confidence scores
given by `X`.}

\item{nthreads}{Number of parallel threads to use for further computations.}
}
\value{
A `CMF` (if passing `implicit=FALSE`) or `CMF_implicit` (if passing
`implicit=TRUE`) model object without side information, for which the usual
prediction functions such as \link{topN} and \link{topN_new} can be used as if
it had been fitted through this software.
}
\description{
Creates a `CMF` or `CMF_implicit` model object based on fitted
latent factor matrices, which might have been obtained from a different software.
For example, the package `recosystem` has functionality for obtaining these matrices,
but not for producing recommendations or latent factors for new users, for which
this function can come in handy as it will turn such model into a `CMF` model which
provides all such functionality.

This is only available for models without side information, and does not support
user/item mappings.
}
\examples{
### Example 'adopting' a model from 'recosystem'
library(cmfrec)
library(recosystem)
library(recommenderlab)
library(MatrixExtra)

### Fitting a model with 'recosystem'
data("MovieLense")
X <- as.coo.matrix(MovieLense@data)
r <- Reco()
r$train(data_memory(X@i, X@j, X@x, index1=FALSE),
        out_model = file.path(tempdir(), "model.txt"),
        opts = list(dim=10, costp_l2=0.1, costq_l2=0.1,
                    verbose=FALSE, nthread=1))
matrices <- r$output(out_memory(), out_memory())
glob_mean <- mean(X@x)

### Now converting it to CMF
model <- CMF.from.model.matrices(
    A=t(matrices$P), B=t(matrices$Q),
    glob_mean=glob_mean,
    lambda=0.1, scale_lam=TRUE,
    implicit=FALSE, nonneg=FALSE,
    nthreads=1
)

### Make predictions about new users
factors_single(model, X[10,,drop=TRUE])
topN_new(model,
         X=X[10,,drop=TRUE],
         exclude=X[10,,drop=TRUE])
}
