% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{swap.users.and.items}
\alias{swap.users.and.items}
\title{Swap users and items in the model}
\usage{
swap.users.and.items(model, precompute = TRUE)
}
\arguments{
\item{model}{A collective matrix factorization model from this package - see
\link{fit_models} for details.}

\item{precompute}{Whether to calculate the precomputed matrices for speeding up
predictions in new data.}
}
\value{
The same model object as before, but with the internal data
swapped in order to make predictions about items. If passing `precompute=TRUE`,
it will also generate precomputed matrices which can be used to speed up predictions.
}
\description{
This function will swap the users and items in a given matrix
factorization model. Since the package functionality is user-centric, it
is generally not possible or not efficient to make predictions about items
(e.g. recommend users for a given item or calculate new item factors).

This function allows using the same API while avoiding model refitting or deep
copies of data by simply swapping the matrices, IDs, and hyperparameters
as necessary.

The resulting object can be used with the same functions as the original,
such as \link{topN} or \link{factors}, but any mention of "user" in the
functions will now mean "items".
}
\examples{
library(cmfrec)

### Generate a small random matrix
n_users <- 10L
n_items <- 8L
k <- 3L
set.seed(1)
X <- matrix(rnorm(n_users*n_items), nrow=n_users)

### Factorize it
model <- CMF(X, k=k, verbose=FALSE, nthreads=1L)

### Now swap the users and items
model.swapped <- swap.users.and.items(model)

### These will now throw the same result
### (up to numerical precision)
item_factors(model, X[, 1])
factors_single(model.swapped, X[, 1])

### Swapping it again restores the original
model.restored <- swap.users.and.items(model.swapped)

### These will throw the same result
topN(model, user=2, n=3)
topN(model.restored, user=2, n=3)

### The procedure did not create any deep copies
ptr_A <- tracemem(model$matrices$A)
ptr_B <- tracemem(model.swapped$matrices$B)
ptr_A == ptr_B
untracemem(model$matrices$A)
untracemem(model.swapped$matrices$B)
}
