% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_calcs.R
\name{calc_logReturnProb_fevd}
\alias{calc_logReturnProb_fevd}
\title{Calculates log return probability and standard error given return value(s) of interest}
\usage{
calc_logReturnProb_fevd(fit, returnValue, covariates = NULL, getSE = TRUE,
  scaling = 1)
}
\arguments{
\item{fit}{fitted object from \pkg{extRemes} \code{fevd}}

\item{returnValue}{value(s) for which log return probability is desired}

\item{covariates}{matrix of covariate values, each row a set of covariates for which the return probability is desired}

\item{getSE}{logical indicating whether standard error is desired, in addition to the point estimate}

\item{scaling}{if \code{returnValue} is scaled for numerics, this allows names of output to be on original scale}
}
\description{
Calculates log return probability given return value(s) of interest, using model fit from \code{extRemes::fevd}. Standard error is obtained via the delta method. The return probability is the probability of exceeding the return value in a single block. For non-stationary models (those that include covariates for the location, scale, and/or shape parameters, log probabilities and standard errors are returned for as many sets of covariates as provided.
}
\details{
Results are calculated (and returned) on log scale as delta-method based standard errors are more accurate for the log probability. Confidence intervals on the probability scale should be calculated by calculating a confidence interval for the log probability and exponentiating the endpoints of the interval.
}

