% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_ratio.R
\name{calc_riskRatio_pot}
\alias{calc_riskRatio_pot}
\title{Compute risk ratio and uncertainty based on peaks-over-threshold models fit to exceedances over a threshold}
\usage{
calc_riskRatio_pot(returnValue, y1, y2, x1 = NULL, x2 = x1, threshold1,
  threshold2 = threshold1, locationFun1 = NULL,
  locationFun2 = locationFun1, scaleFun1 = NULL, scaleFun2 = scaleFun1,
  shapeFun1 = NULL, shapeFun2 = shapeFun1, nBlocks1 = nrow(x1),
  nBlocks2 = nrow(x2), blockIndex1 = NULL, blockIndex2 = NULL,
  firstBlock1 = 1, firstBlock2 = 1, index1 = NULL, index2 = NULL,
  nReplicates1 = 1, nReplicates2 = 1, replicateIndex1 = NULL,
  replicateIndex2 = NULL, weights1 = NULL, weights2 = NULL,
  proportionMissing1 = NULL, proportionMissing2 = NULL, xNew1 = NULL,
  xNew2 = NULL, declustering = NULL, upperTail = TRUE, scaling1 = 1,
  scaling2 = 1, ciLevel = 0.9, bootSE = FALSE, bootControl = list(seed =
  0, n = 250, by = "block"), lrtCI = FALSE, lrtControl = list(bounds =
  c(0.01, 100)), optimArgs = list(method = "Nelder-Mead"))
}
\arguments{
\item{returnValue}{numeric value giving the value for which the risk ratio should be calculated, where the resulting period will be the average number of blocks until the value is exceeded and the probability the probability of exceeding the value in any single block.}

\item{y1}{a numeric vector of exceedance values for the first dataset (values of the outcome variable above the threshold).}

\item{y2}{a numeric vector of exceedance values for the second dataset (values of the outcome variable above the threshold).}

\item{x1}{a data frame, or object that can be converted to a data frame with columns corresponding to covariate/predictor/feature variables and each row containing the values of the variable for a block (e.g., often a year with climate data) for the first dataset. The number of rows must equal the number of blocks.}

\item{x2}{analogous to \code{x1} but for the second dataset}

\item{threshold1}{a single numeric value for constant threshold or a numeric vector with length equal to the number of blocks, indicating the threshold for each block for the first dataset.}

\item{threshold2}{analogous to \code{threshold1} but for the second dataset}

\item{locationFun1}{formula, vector of character strings, or indices describing a linear model (i.e., regression function) for the location parameter using columns from \code{x1} for the first dataset. \code{x1} must be supplied if this is anything other than NULL or ~1.}

\item{locationFun2}{formula, vector of character strings, or indices describing a linear model (i.e., regression function) for the location parameter using columns from \code{x2} for the second dataset. \code{x2} must be supplied if this is anything other than NULL or ~1.}

\item{scaleFun1}{formula, vector of character strings, or indices describing a linear model (i.e., regression function) for the log of the scale parameter using columns from \code{x1} for the first dataset.  \code{x1} must be supplied if this is anything other than NULL or ~1.}

\item{scaleFun2}{formula, vector of character strings, or indices describing a linear model (i.e., regression function) for the log of the scale parameter using columns from \code{x2} for the second dataset.  \code{x2} must be supplied if this is anything other than NULL or ~1.}

\item{shapeFun1}{formula, vector of character strings, or indices describing a linear model (i.e., regression function) for the shape parameter using columns from \code{x1} for the first dataset.  \code{x1} must be supplied if this is anything other than NULL or ~1.}

\item{shapeFun2}{formula, vector of character strings, or indices describing a linear model (i.e., regression function) for the shape parameter using columns from \code{x2} for the first dataset.  \code{x2} must be supplied if this is anything other than NULL or ~1.}

\item{nBlocks1}{number of blocks (e.g., a block will often be a year with climate data) in first dataset; note this value determines the interpretation of return values/periods/probabilities; see \code{returnPeriod} and \code{returnValue}.}

\item{nBlocks2}{number of blocks (e.g., a block will often be a year with climate data) in second dataset; note this value determines the interpretation of return values/periods/probabilities; see \code{returnPeriod} and \code{returnValue}.}

\item{blockIndex1}{numeric vector providing the index of the block corresponding to each element of \code{y1}. Used only when \code{x1} is provided to match exceedances to the covariate/predictor/feature value for the exceedance or when using bootstrapping with the resampling based on blocks based on the \code{by} element of \code{bootControl}. If \code{firstBlock1} is not equal to one, then \code{blockIndex1} need not have one as its smallest possible value.}

\item{blockIndex2}{numeric vector providing the index of the block corresponding to each element of \code{y2}. Analogous to \code{blockIndex1}.}

\item{firstBlock1}{single numeric value indicating the numeric value of the first possible block of \code{blockIndex1}. For example the values in \code{blockIndex1} might indicate the year of each exceedance with the first year of data being 1969, in which case \code{firstBlock1} would be 1969. Note that the first block may not have any exceedances so it may not be represented in \code{blockIndex1}. Used only to adjust \code{blockIndex1} so that the block indices start at one and therefore correspond to the rows of \code{x1}.}

\item{firstBlock2}{single numeric value indicating the numeric value of the first possible block of \code{blockIndex2}. Analogous to \code{firstBlock1}.}

\item{index1}{(optional) numeric vector providing the integer-valued index (e.g., julian day for daily climate data) corresponding to each element of \code{y1}. For example if there are 10 original observations and the third, fourth, and seventh values are exceedances, then \code{index1} would be the vector 3,4,7. Used only when \code{declustering} is provided to determine which exceedances occur sequentially or within a contiguous set of values of a given length. The actual values are arbitrary; only the lags between the values are used.}

\item{index2}{(optional) numeric vector providing the integer-valued index (e.g., julian day for daily climate data) corresponding to each element of \code{y2}. Analogous to \code{index1}.}

\item{nReplicates1}{numeric value indicating the number of replicates for the first dataset.}

\item{nReplicates2}{numeric value indicating the number of replicates for the second dataset.}

\item{replicateIndex1}{numeric vector providing the index of the replicate corresponding to each element of \code{y1}. Used for three purposes: (1) when using bootstrapping with the resampling based on replicates based on the \code{by} element of \code{bootControl}, (2) to avoid treating values in different replicates as potentially being sequential or within a short interval when removing values based on \code{declustering}, and (3) to match outcomes to \code{weights} or \code{proportionMissing} when either vary by replicate.}

\item{replicateIndex2}{numeric vector providing the index of the replicate corresponding to each element of \code{y2}. Analogous to \code{replicateIndex1}.}

\item{weights1}{a vector or matrix providing the weights by block for the first dataset. When there is only one replicate or the weights do not vary by replicate, a vector of length equal to the number of blocks. When weights vary by replicate, a matrix with rows corresponding to blocks and columns to replicates. Likelihood contribution of each block is multiplied by the corresponding weight.}

\item{weights2}{a vector or matrix providing the weights by block for the second dataset. Analogous to \code{weights1}.}

\item{proportionMissing1}{a numeric value, vector or matrix indicating the proportion of missing values in the original first dataset before exceedances were selected. When the proportion missing is the same for all blocks and replicates, a single value. When there is only one replicate or the weights do not vary by replicate, a vector of length equal to the number of blocks. When weights vary by replicate, a matrix with rows corresponding to blocks and columns to replicates.}

\item{proportionMissing2}{a numeric value, vector or matrix indicating the proportion of missing values in the original second dataset before exceedances were selected. Analogous to \code{proportionMissing1}.}

\item{xNew1}{object of the same form as \code{x1}, providing covariate/predictor/feature values for which log risk ratios are desired.}

\item{xNew2}{object of the same form as \code{x2}, providing covariate/predictor/feature values for which log risk ratios are desired. Must provide the same number of covariate sets as \code{xNew1} as the risk ratio is based on contrasting return probabilities under \code{xNew1} and \code{xNew2}.}

\item{declustering}{one of \code{NULL}, \code{"noruns"}, or a number. If 'noruns' is specified, only the maximum (or minimum if upperTail = FALSE) value within a set of exceedances corresponding to successive indices is included. If a number, this should indicate the size of the interval (which will be used with the \code{index} argument) within which to allow only the largest (or smallest if upperTail = FALSE) value.}

\item{upperTail}{logical indicating whether one is working with exceedances over a high threshold (TRUE) or exceedances under a low threshold (FALSE); in the latter case, the function works with the negative of the values and the threshold, changing the sign of the resulting location parameters.}

\item{scaling1}{positive-valued scalar used to scale the data values of the first dataset for more robust optimization performance. When multiplied by the values, it should produce values with magnitude around 1.}

\item{scaling2}{positive-valued scalar used to scale the data values of the second dataset for more robust optimization performance. When multiplied by the values, it should produce values with magnitude around 1.}

\item{ciLevel}{statistical confidence level for confidence intervals; in repeated experimentation, this proportion of confidence intervals should contain the true risk ratio. Note that if only one endpoint of the resulting interval is used, for example the lower bound, then the effective confidence level increases by half of one minus \code{ciLevel}. For example, a two-sided 0.90 confidence interval corresponds to a one-sided 0.95 confidence interval.}

\item{bootSE}{logical indicating whether to use the bootstrap to estimate standard errors.}

\item{bootControl}{a list of control parameters for the bootstrapping. See \code{Details}.}

\item{lrtCI}{logical indicating whether to calculate a likelihood ratio-based confidence interval}

\item{lrtControl}{list containing a single component, \code{bounds}, which sets the range inside which the algorithm searches for the endpoints of the likelihood ratio-based confidence interval. This avoids numerical issues with endpoints converging to zero and infinity. If an endpoint is not found within the interval, it is set to \code{NA}.}

\item{optimArgs}{a list with named components matching exactly any arguments that the user wishes to pass to \code{optim}. See \code{help(optim)} for details. Of particular note, \code{'method'} can be used to choose the optimization method used for maximizing the log-likelihood to fit the model and \code{'control=list(maxit=VALUE)'} for a user-chosen VALUE can be used to increase the number of iterations if the optimization is converging slowly.}
}
\description{
Compute risk ratio and uncertainty by fitting peaks-over-threshold model, designed specifically for climate data, to exceedance-only data, using the point process approach. The risk ratio is the ratio of the probability of exceedance of a pre-specified value under the model fit to the first dataset to the probability under the model fit to the second dataset. Default standard errors are based on the usual MLE asymptotics using a delta-method-based approximation, but standard errors based on the nonparametric bootstrap and on a likelihood ratio procedure can also be computed.
}
\details{
See \code{\link{fit_pot}} for more details on fitting the peaks-over-threshold model for each dataset, including details on blocking and replication. Also see \code{\link{fit_pot}} for information on the \code{bootControl} argument.
}
\examples{
# need examples
}
\author{
Christopher J. Paciorek
}
\references{
Jeon S., C.J. Paciorek, and M.F. Wehner. 2016. Quantile-based bias correction and uncertainty quantification of extreme event attribution statements. Weather and Climate Extremes. In press. arXiv preprint: http://arxiv.org/abs/1602.04139.
}

