% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latitudinalMean.R
\name{latitudinalMean}
\alias{latitudinalMean}
\title{latitudinalMean}
\usage{
latitudinalMean(rasterForCalculation)
}
\arguments{
\item{rasterForCalculation}{A raster that contains data for plotting according to latitudinal value}
}
\value{
A vector of raster values for each absolute value of latitude.
}
\description{
A function to calculate mean values of a raster at every line of latitude, at the resolution of a given raster layer. Put another way, for each row in the raster, it calculates a mean.
}
\examples{

data(precipDeviation);
precipStability <- 1/precipDeviation;
latMean <- absLatitudinalMean(rasterForCalculation = precipStability);
plot(latMean, main = "Precipitation Stability by Latitude",
ylab = "Relative Stability", type = "l");

}
\references{
Owens, HL, and RP Guralnick. Submitted, Biodiversity Informatics.
}
\seealso{
\code{\link{absLatitudinalMean}} to calculate mean value for each absolute value of latitude.
}
\keyword{manip}
