% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scripts.R
\name{run_template}
\alias{run_template}
\title{Run a template script}
\usage{
run_template(id, arguments, JSONValue = FALSE, ...)
}
\arguments{
\item{id}{id of the template script.}

\item{arguments}{list of arguments to the script.}

\item{JSONValue}{bool (default FALSE) If true, returns the 
JSON values instead of the file_ids}

\item{...}{additional arguments to \code{scripts_post_custom}}
}
\value{
If JSONValue is FALSE, File ids of any run outputs are returned.
        If JSONValue is TRUE, JSON values of first JSON run output is returned.
          If there are no JSON outputs, warning message is printed
            and nothing is returned
          If there are more than 1 JSON outputs, warning message is printed 
            and the first JSON output is returned.
}
\description{
Run a template script
}
\examples{
\dontrun{
# Try a search for the template id
search_list('template name', type = 'template_script')

# Run the template
run_template(id, arguments = list(arg1 = 1, arg2 = 2), ...)

# Run the template and return JSON value outputs
run_template(id, arguments = list(arg1 = 1, arg2 = 2), JSONValue=TRUE, ...)
}
}
\seealso{
Other script_utils: \code{\link{civis_script}},
  \code{\link{fetch_output_file_ids}},
  \code{\link{run_civis}}
}
\concept{script_utils}
