#' Circumplex Scales of Interpersonal Efficacy
#'
#' Information about the Circumplex Scales of Interpersonal Efficacy.
#'
#' @source \url{https://www.webpages.uidaho.edu/klocke/csie.htm}
#' @examples
#' instrument("csie")
#' summary(csie)
"csie"

#' Circumplex Scales of Intergroup Goals
#'
#' Information about the Circumplex Scales of Intergroup Goals.
#'
#' @source \url{https://www.webpages.uidaho.edu/klocke/csig.htm}
#' @examples
#' instrument("csig")
#' summary(csig)
"csig"

#' Circumplex Scales of Interpersonal Problems
#'
#' Information about the Circumplex Scales of Interpersonal Problems.
#'
#' @source \url{https://doi.org/10.1037/pas0000505}
#' @examples
#' instrument("csip")
#' summary(csip)
"csip"

#' Circumplex Scales of Interpersonal Values
#'
#' Information about the Circumplex Scales of Interpersonal Values.
#'
#' @source \url{https://www.webpages.uidaho.edu/klocke/csiv.htm}
#' @examples
#' instrument("csiv")
#' summary(csiv)
"csiv"

#' Interpersonal Goals Inventory for Children, Revised Version
#'
#' Information about the Interpersonal Goals Inventory for Children, Revised Version.
#'
#' @source \url{https://doi.org/10.1177/1073191111411672}
#' @examples
#' instrument("igicr")
#' summary(igicr)
"igicr"

#' Inventory of Interpersonal Problems, Brief Version
#'
#' Information about the Inventory of Interpersonal Problems, Brief Version.
#' Note that, although we have permission to provide some information about the
#' IIP-32, Mind Garden Inc. has exclusive rights to distribute it in full.
#'
#' @source \url{https://www.mindgarden.com/113-inventory-of-interpersonal-problems}
#' @examples
#' instrument("iip32")
#' summary(iip32)
"iip32"

#' Inventory of Interpersonal Problems
#'
#' Information about the Inventory of Interpersonal Problems. Note that,
#' although we have permission to provide some information about the IIP-64,
#' Mind Garden Inc. has exclusive rights to distribute it in full.
#'
#' @source \url{https://www.mindgarden.com/113-inventory-of-interpersonal-problems}
#' @examples
#' instrument("iip64")
#' summary(iip64)
"iip64"

#' Inventory of Interpersonal Problems, Short Circumplex
#'
#' Information about the Inventory of Interpersonal Problems Short Circumplex.
#'
#' @source \url{https://doi.org/10.1080/00223890802388665}
#' @examples
#' instrument("iipsc")
#' summary(iipsc)
"iipsc"

#' Inventory of Interpersonal Strengths, Brief Version
#'
#' Information about the Inventory of Interpersonal Strengths, Brief Version.
#'
#' @source \url{https://doi.org/10.1080/00223891.2012.681818}
#' @examples
#' instrument("iis32")
#' summary(iis32)
"iis32"

#' Inventory of Interpersonal Strengths
#'
#' Information about the Inventory of Interpersonal Strengths.
#'
#' @source \url{https://doi.org/10.1037/a0017269}
#' @examples
#' instrument("iis64")
#' summary(iis64)
"iis64"

#' IPIP Interpersonal Circumplex
#'
#' Information about the IPIP Interpersonal Circumplex.
#'
#' @source \url{https://doi.org/10.1177/1073191109340382}
#' @examples
#' instrument("ipipipc")
#' summary(ipipipc)
"ipipipc"

#' Interpersonal Sensitivities Circumplex
#'
#' Information about the Interpersonal Sensitivities Circumplex.
#'
#' @source \url{https://doi.org/10.1111/j.1467-6494.2011.00696.x}
#' @examples
#' instrument("isc")
#' summary(isc)
"isc"

#' Inventory of Influence Tactics Circumplex
#' 
#' Information about the Inventory of Influence Tactics Circumplex.
#' 
#' @source \url{https://doi.org/10.1177/1073191119864661}
#' @examples
#' instrument("iitc")
#' summary(iitc)
"iitc"
