% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterative.r
\name{iterCIR}
\alias{iterCIR}
\title{Centered-isotonic-regression (CIR): iterative version for better bias correction}
\usage{
iterCIR(y, outx = NULL, tol = 0.001, maxit = 10, full = FALSE, ...)
}
\arguments{
\item{y}{See \code{\link{cirPAVA}}}

\item{outx}{vector of x values for which predictions will be made. If \code{NULL} (default), this will be set to the set of unique values in the \code{x} argument (or equivalently in \code{y$x}).}

\item{tol}{The iteration's convergence tolerance level (default 1e-3)}

\item{maxit}{integer, maximum number of iterations (default 10)}

\item{full}{logical, is a more complete output desired? if \code{FALSE} (default), only a vector of point estimates for y at the provided dose levels is returned}

\item{...}{Other arguments passed on to \code{\link{cirPAVA}}}
}
\value{
under default, returns a vector of y estimates at unique x values. With \code{full=TRUE}, returns a list of 3 \code{\link{doseResponse}} objects named \code{output,input,shrinkage} for the output data at dose levels, the input data, and the function as fit at algorithm-generated points, respectively.
}
\description{
EXPERIMENTAL: Nonparametric forward point estimation of a monotone response (y) as a function of dose (x), using an iterative version of the centered-isotonic-regression (CIR) algorithm. The code works, but delivers marginal improvement at greater computational cost (an issue if you simulate a large ensemble), and somewhat convoluted interpretation. Use at your own risk.
For explanation, see Oron and Flournoy (2017), Section 3.2.
}
\seealso{
\code{\link{cirPAVA}},\code{\link{quickIsotone}}
}
