% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetching.R
\name{datasets}
\alias{datasets}
\title{Download a database extract from \code{chronosphere} remote server}
\usage{
datasets(
  dat = NULL,
  datadir = NULL,
  verbose = FALSE,
  master = FALSE,
  greetings = TRUE
)
}
\arguments{
\item{dat}{\code{character}. Database ID. If this is set to \code{NULL}, then a simplified list of availables variables will be downloaded, including all \code{dat} and \code{var} combinations. If \code{dat} is a valid database ID, then all accessible resolutions and version of a dataset are shown.}

\item{datadir}{\code{character} Directory where the downloaded files are kept. Individual entries will be looked up from the directory if this is given, and will be downloaded if they are not found. The default \code{NULL} option will download data to a temporary directory that exists only until the R session ends.}

\item{verbose}{\code{logical} Should console feedback during download be displayed?}

\item{master}{\code{logical} When \code{dat} is \code{NULL}, should the function download the master records file?}

\item{greetings}{\code{logical} When the function is invoked without arguments, it displays a message to keep new users informed about different versions and resolutions (even with \code{verbose=FALSE}). This argument turns this message off on demand.}
}
\value{
A \code{data.frame} class object.
}
\description{
The function will download a list of available data from the data repository
}
\details{
The function will download a single .csv file and attach it as a \code{data.frame}.
}
\examples{
# available datasets and variables - proper
# ind <- datasets()
# available datasets and variables
# just one example archive is available locally
ind <- datasets(
  datadir=system.file("extdata", package="chronosphere"))
# all available versions and resolutions in database 'paleomap'
# oneDat <- datasets("paleomap")
}
