% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country.R
\name{country_choropleth}
\alias{country_choropleth}
\title{Create a choropleth map using country-level data}
\usage{
country_choropleth(
  df,
  geoid.name = "region",
  geoid.type = "auto",
  value.name = "value",
  num_colors = 7,
  color.max = NULL,
  color.min = NULL,
  na.color = "grey",
  custom.colors = NULL,
  nbreaks = 5,
  zoom = NULL,
  continent_zoom = NULL,
  projection = "cartesian",
  limits_lat = NULL,
  limits_lon = NULL,
  reproject = TRUE,
  border_color = "grey15",
  border_thickness = 0.2,
  background_color = "white",
  gridlines = FALSE,
  latlon_ticks = FALSE,
  whitespace = TRUE,
  label = NULL,
  label_text_size = 3,
  label_text_color = "black",
  label_box_color = "white",
  ggrepel_options = NULL,
  legend = NULL,
  legend_position = "right",
  title = NULL,
  return = "plot"
)
}
\arguments{
\item{df}{A dataframe containing country level data}

\item{geoid.name}{The variable that identifies each country}

\item{geoid.type}{How the variable given by geoid.name specifies each
country. The allowed geoid.type are given by the columns name.proper,
name.lower, iso_a3, and iso_a2 in choroplethr::country.regions. If "auto",
the function will try to automatically determine geoid.type.}

\item{value.name}{The name of the variable you wish to plot.}

\item{num_colors}{The number of colors you want in your graph when plotting
continuous data. If num_colors > 1, the variable in question will be
divided into quantiles and converted into a factor with that many levels.
If num_colors = 1, a continuous color gradient will be used; if num_colors = 0,
a diverging color gradient will be used (useful for visualizing negative
and positive numbers).  Use color.max and color.min to control the range of
colors displayed. num_colors is ignored when plotting categorical data.}

\item{color.max}{The color of the highest value in your data. Ignored if the
plotted variable is categorical.}

\item{color.min}{The color of the lowest value in your data. Ignored if the
plotted variable is categorical.}

\item{na.color}{The color you want to assign for regions with missing data}

\item{custom.colors}{A vector of valid R color terms of the to use for the
map when plotting factor variables. The length of this vector must match
the number of levels in your factor variable, or num_colors for a
continuous variable that will be discretized by the function, and the order
should match the order of the levels of in your factor variable.}

\item{nbreaks}{The number of breaks you wish to show in the legend when using
a continuous color scale. Ignored if num_colors > 1.}

\item{zoom}{An optional vector of countries to zoom in on, written in the
same manner as geoid.name.}

\item{continent_zoom}{Zoom in on a particular continent; to see which
countries belong to which continent, see choroplethr::country.regions}

\item{projection}{One of the following: "cartesian", "mercator", "robinson",
or "albers", for equirectangular, Mercator, Robinson, and Albers Equal Area
projections, respectively. When using the Mercator projection for world
maps, setting limits_lon is recommended to prevent exaggeration of the size
of Antarctica.}

\item{limits_lat}{A length two vector giving the minimum and maximum latitude
you wish to include in your map.}

\item{limits_lon}{A length two vector giving the minimum and maximum
longitude you wish to include in your map.}

\item{reproject}{If TRUE, the map will be cropped and centered prior to
applying the projection. This will generally result in a better figure when
using the Robinson and Albers, but may lead to countries near the edge of
the map being occluded.}

\item{border_color}{The color of the borders on your map}

\item{border_thickness}{The thickness of the borders on your map}

\item{background_color}{The background color of your map}

\item{gridlines}{Should gridlines appear on your map?}

\item{latlon_ticks}{Should lat/lon tick marks appear on the edge of your map?}

\item{whitespace}{Add some blank space to the sides of your map? For some
projections, this must be set to FALSE in order for lat/lon ticks and
display correctly.}

\item{label}{The name of variable you wish to use to label your map; must be
one of the variables that appears in the spatial dataframe just prior
plotting (use return = 'sf' to see this dataframe), and in general, can be
any of the allowed geoid.type. This function uses ggplot2::geom_label_repel
to create the labels and ensure that they do not overlap.}

\item{label_text_size}{The size of the text that will appear in each label}

\item{label_text_color}{The color of the text that will appear in each label}

\item{label_box_color}{The color of the box around each label}

\item{ggrepel_options}{A list containing additional arguments to be passed to
geom_label_repel (see ?ggplot2::geom_label_repel)}

\item{legend}{A title for your legend; if NULL, value.name will be used.}

\item{legend_position}{The position of your legend relative to the rest of
the map; can be "top", "bottom", "left", or "right".}

\item{title}{A title for your plot; if NULL, no title will be added.}

\item{return}{If "plot", the function will return the requested map as a
ggplot object. If "sf", the function will return the spatial dataframe used
to draw the map (useful if you wish to customize the map yourself).}
}
\description{
See choroplethr::country.regions for an object which can help you coerce your
country names into the required format; the allowed geoid for this function
are columns name.proper, name.lower, iso_a3, and iso_a2 which appear at the
beginning of this object.
}
\examples{
# Create a choropleth map using country level data:
data(df_country_demographics)
country_choropleth(df_country_demographics, geoid.name = 'region', geoid.type = 'iso_a3',
                   value.name = 'gdp',
                   title = "GDP of Countries in the World", legend = 'GDP (millions)')

# Use a divergent continuous color scale and customize map appearance:
country_choropleth(df_country_demographics, geoid.name = 'region', geoid.type = 'iso_a3',
                   value.name = 'gdp', num_colors = 0, border_color = 'grey', 
                   color.max = 'gold', color.min = 'navyblue',
                   projection = 'robinson', latlon_ticks = TRUE, 
                   gridlines = TRUE, whitespace = FALSE,
                   background_color = 'azure',
                   title = "GDP of Countries in the World", legend = 'GDP (millions)')

# Zoom in on South America:
country_choropleth(df_country_demographics, geoid.name = 'region', geoid.type = 'iso_a3',
                   value.name = 'gdp', num_colors = 0, border_color = 'grey', 
                   continent_zoom = 'South America',
                   color.max = 'gold', color.min = 'navyblue',
                   projection = 'robinson', latlon_ticks = TRUE, 
                   gridlines = TRUE, whitespace = FALSE,
                   background_color = 'azure',
                   title = "GDP of Countries in the World", legend = 'GDP (millions)',
                   label = 'iso_a2', label_text_size = 5)
}
