% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nas.R
\name{num_na}
\alias{num_na}
\alias{which_na}
\alias{which_not_na}
\alias{row_na_counts}
\alias{col_na_counts}
\alias{row_all_na}
\alias{col_all_na}
\alias{row_any_na}
\alias{col_any_na}
\title{Efficient functions for dealing with missing values.}
\usage{
num_na(x)

which_na(x)

which_not_na(x)

row_na_counts(x)

col_na_counts(x)

row_all_na(x)

col_all_na(x)

row_any_na(x)

col_any_na(x)
}
\arguments{
\item{x}{A vector, matrix or data frame.}
}
\value{
Number or location of \code{NA} values.
}
\description{
\code{num_na(x)} is a faster and more efficient \code{sum(is.na(x))}. \cr
\code{which_na(x)} is a more efficient \code{which(is.na(x))} \cr
\code{which_not_na(x)} is a more efficient \code{which(!is.na(x))} \cr
\code{row_na_counts(x)} is a more efficient \code{rowSums(is.na(x))} \cr
\code{row_all_na()} returns a logical vector indicating which rows are empty
and have only \code{NA} values. \cr
\code{row_any_na()} returns a logical vector indicating which rows have at least
1 \code{NA} value. \cr
The \code{col_} variants are the same, but operate by-column.
}
\details{
These functions are designed primarily for programmers, to increase the speed
and memory-efficiency of \code{NA} handling. \cr
All these functions can be parallelised through \code{options(cheapr.cores)}. \cr
When \code{x} is a data frame, \code{num_na}, \code{which_na} and \code{which_not_na} define a
missing value as an empty row with only \code{NA} values across all columns.
To get the number of \code{NA} values across an entire data frame,
use \code{sum(col_na_counts(data))}. \cr
To replicate \code{complete.cases(x)}, use \code{!row_any_na(x)}.
}
\examples{
library(cheapr)
library(bench)

x <- 1:10
x[c(1, 5, 10)] <- NA
num_na(x)
which_na(x)
which_not_na(x)

row_nas <- row_na_counts(airquality)
col_nas <- col_na_counts(airquality)
names(row_nas) <- rownames(airquality)
names(col_nas) <- colnames(airquality)
row_nas
col_nas

df <- airquality[, 1:2]

# Number of empty rows
num_na(df)
# Which rows are empty?
which_na(df)
df[which_na(df), ]

# Removing the empty rows
df[which_not_na(df), ]

}
