% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_measures.r
\name{get_measures}
\alias{get_measures}
\title{Retrieve Measures Specified for Waterbodies}
\usage{
get_measures(ea_name = NULL, column = NULL)
}
\arguments{
\item{ea_name}{A string representing the description (\code{name} for 
\code{OC}, \code{MC} or \code{RBD} level downloads or \code{WBID} for 
individual waterbodies) of the features to be extracted. For example 
to extract data for the whole of the Humber RBD, this would be "Humber"; 
also see examples. Must be anexact match to the values used in the EA 
database. Use the \code{\link{search_names}} function to search for 
specific values.}

\item{column}{The column to be searched. Possible options are
\code{WBID} (waterbody id), \code{OC} (Operational Catchment), \code{MC}
(Management Catchment) and \code{RBD} (River Basin District).}
}
\value{
An object of class \code{cde_df} containing the details 
of the measures put in place to try and improve water quality.
For details of the meaning of the the different columns returned, 
see \url{https://docs.ropensci.org/cde/articles/cde-output-reference.html}.
}
\description{
Retrieves details of the measures put in place or proposed 
for specified waterbodies to try and achieve the status objectives set
for 2021 from the EA Catchment Data Explorer site.
Data can be retrieved by specifying  Management Catchment (\code{MC}), 
Operational Catchment (\code{OC}) or River Basin District (\code{RBD}).
Note that Measures data are patchy as only measures explicitly linked 
to a target change in status are included. Therefore in many cases 
the function will return an empty dataframe with a message.
}
\examples{
# get the measures put in place for the Thames RBD
get_measures(ea_name="Thames", column="RBD")

# get the measures put in place for the Loddon Operational Catchment
get_measures(ea_name="Loddon", column="OC")

}
