% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storeAnswer.R
\name{storeAnswer}
\alias{storeAnswer}
\alias{storeAnswer,Cat-method}
\alias{storeAnswer,character-method}
\title{Update Answer to Single Item}
\usage{
\S4method{storeAnswer}{Cat}(catObj, item, answer, returnJSON = FALSE)

\S4method{storeAnswer}{character}(catObj, item, answer, returnJSON = FALSE)
}
\arguments{
\item{catObj}{An object of class \code{Cat} or class \code{json}.}

\item{item}{An integer indicating the index of the question item}

\item{answer}{The answer to the \code{item} to be updated}

\item{returnJSON}{Boolean indicating whether the updated \code{Cat} object should be returned as a JSON object.  Defaults to FALSE.}
}
\value{
The function \code{storeAnswer} returns an updated object of class \code{Cat} with the \code{answers} slot reflecting the newly stored \code{answer} to the indicated \code{item}.  All previously stored answers remain the same, and all unanswered questions remain \code{NA}.
}
\description{
Stores answer to item \eqn{k} to the \code{Cat} object's \code{answers} slot.
}
\details{
The function \code{storeAnswer} updates the \code{Cat} object, but the updated object must be assigned to an object for the changes to be stored.  See \strong{Examples}.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Printing current answers slot
getAnswers(ltm_cat)

## Storing answer of 0 to item 1
ltm_cat <- storeAnswer(ltm_cat, item = 1, answer = 0)

## Now object reflects answer to item 1
getAnswers(ltm_cat)


}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery, Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
