% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateThetas.R
\name{simulateThetas}
\alias{simulateThetas}
\title{Estimates theta under different adaptive battery specifications}
\usage{
simulateThetas(catObjs = list(), responses)
}
\arguments{
\item{catObjs}{A list of \code{Cat} objects of the same model with different adaptive battery specifications}

\item{responses}{A matrix of response profiles}
}
\value{
The function \code{allFish} returns a dataframe where each \code{Cat} object corresponds to a column and each respondent corresponds to a row.
}
\description{
Takes in response profiles from multiple respondents and multiple Cat object (i.e., adaptive battery) specifications and returns a set of theta estimates
}
\details{
The function takes multiple \code{Cat} objects, stored in a list, and generates an estimation for \code{theta}.
}
\examples{

# Load Cat object
data(grm_cat)
   
# Simulate respondents
# Simulate respondents
respondents <- plyr::adply(.data = matrix(c(-1, 0, 1)),
                           .margins = 1,
                           .id = NULL,
                           .fun = simulateRespondents, cat = grm_cat, n = 10)
 
# A stopping rule (here, a common one) is required
grm_cat@lengthThreshold <- 3

# Specify different adaptive inventory procedures
grm_MAP <- grm_EAP <- grm_cat
grm_MAP@estimation <- "MAP"
grm_EAP@estimation <- "EAP"

# List of Cat objects 
grmList <- list(grm_MAP, grm_EAP)

# Results
theta_est_results <- simulateThetas(catObjs = grmList, responses = respondents)

}
\seealso{
\code{\link{Cat-class}}, \code{\link{apply}}, \code{\link{selectItem}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery, Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil, Jaerin Kim, Dominique Lockett
}
