% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{estimateTheta}
\alias{estimateTheta}
\title{Estimate of the Respondent's Ability Parameter}
\usage{
estimateTheta(catObj)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}
}
\value{
The function \code{estimateTheta} returns a numeric consisting of the expected value of the respondent's ability parameter.
}
\description{
Estimates the expected value of the ability parameter \eqn{\theta}, conditioned on the observed answers, prior, and the item parameters.
}
\details{
Estimation approach is specified in \code{estimation} slot of \code{Cat} object.

The expected a posteriori approach is used when \code{estimation} slot is \code{"EAP"}.  This method involves integration.  See \strong{Note} for more information.

The modal a posteriori approach is used when \code{estimation} slot is \code{"MAP"}.  This method is only available using the normal prior distribution.

The maximum likelihood approach is used when \code{estimation} slot is \code{"MLE"}.  When the likelihood is undefined,
the MAP or EAP method will be used, determined by what is specified in the \code{estimationDefault} slot in \code{Cat} object.

The weighted maximum likelihood approach is used when \code{estimation} slot is \code{"WLE"}.
Estimating \eqn{\theta} requires root finding with the ``Brent'' method in the GNU Scientific
 Library (GSL) with initial search interval of \code{[-5,5]}.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.

This function uses adaptive quadrature methods from the GNU Scientific
 Library (GSL) to approximate single-dimensional
 integrals with high accuracy.  The bounds of integration are determined by the
 \code{lowerBound} and \code{upperBound} slots of the \code{Cat} object.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## Set different estimation procedures and estimate ability parameter
setEstimation(ltm_cat) <- "EAP"
estimateTheta(ltm_cat)

setEstimation(ltm_cat) <- "MAP"
estimateTheta(ltm_cat)

setEstimation(ltm_cat) <- "MLE"
estimateTheta(ltm_cat)

setEstimation(ltm_cat) <- "WLE"
estimateTheta(ltm_cat)


}
\references{
van der Linden, Wim J. 1998. "Bayesian Item Selection Criteria for Adaptive Testing." Psychometrika
63(2):201-216.

Van der Linden, Wim J., and Peter J. Pashley. 2009. "Item Selection and Ability
 Estimation in Adaptive Testing." Elements of Adaptive Testing. 
 Springer New York, 3-30.
}
\seealso{
\code{\link{Cat-class}}, \code{\link{estimateSE}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
