% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw_alphahull}
\alias{draw_alphahull}
\title{Drawing the alphahull}
\usage{
draw_alphahull(x, y, alpha = 0.5, clr = "black", fill = FALSE, out.rm = TRUE)
}
\arguments{
\item{x}{numeric vector}

\item{y}{numeric vector}

\item{alpha}{transparency value of points}

\item{clr}{optional colour of points and lines, default black}

\item{fill}{Fill the polygon}

\item{out.rm}{option to return the outlier removed alphahull}
}
\value{
A alphahull::ahull(del, alpha = alpha) "gg" object that draws the plot's alpha hull.
}
\description{
This function will draw the alphahull for a
scatterplot.
}
\examples{
require(dplyr)
require(ggplot2)
require(alphahull)
data("features")
nl <- features \%>\% filter(feature == "clusters")
draw_alphahull(nl$x, nl$y)
}
