% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvar-sv.R, R/print-bvharsp.R
\name{bvar_sv}
\alias{bvar_sv}
\alias{print.bvarsv}
\alias{knit_print.bvarsv}
\title{Fitting Bayesian VAR-SV}
\usage{
bvar_sv(
  y,
  p,
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  bayes_spec = set_bvar(),
  include_mean = TRUE,
  minnesota = FALSE,
  verbose = FALSE,
  num_thread = 1
)

\method{print}{bvarsv}(x, digits = max(3L, getOption("digits") - 3L), ...)

knit_print.bvarsv(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{p}{VAR lag}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{bayes_spec}{A BVAR model specification by \code{\link[=set_bvar]{set_bvar()}}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{minnesota}{Apply cross-variable shrinkage structure (Minnesota-way). By default, \code{FALSE}.}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{num_thread}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Number of threads}

\item{x}{\code{bvarsv} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvar_sv()} returns an object named \code{bvarsv} \link{class}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} This function fits VAR-SV.
It can have Minnesota, SSVS, and Horseshoe prior.
}
\details{
Cholesky stochastic volatility modeling for VAR based on
\deqn{\Sigma_t = L^T D_t^{-1} L}
}
\references{
Carriero, A., Chan, J., Clark, T. E., & Marcellino, M. (2022). \emph{Corrigendum to “Large Bayesian vector autoregressions with stochastic volatility and non-conjugate priors” [J. Econometrics 212 (1)(2019) 137–154]}. Journal of Econometrics, 227(2), 506-512.

Chan, J., Koop, G., Poirier, D., & Tobias, J. (2019). \emph{Bayesian Econometric Methods (2nd ed., Econometric Exercises)}. Cambridge: Cambridge University Press.

Cogley, T., & Sargent, T. J. (2005). \emph{Drifts and volatilities: monetary policies and outcomes in the post WWII US}. Review of Economic Dynamics, 8(2), 262–302.

Gruber, L., & Kastner, G. (2022). \emph{Forecasting macroeconomic data with Bayesian VARs: Sparse or dense? It depends!} arXiv.
}
