% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildmertree}
\alias{buildmertree}
\title{Use \code{buildmer} to perform stepwise elimination for \emph{the random-effects part} of \code{lmertree()} and \code{glmertree()} models from package \code{glmertree}}
\usage{
buildmertree(formula, data = NULL, family = gaussian(), cl = NULL,
  direction = "order", crit = "LL", include = NULL,
  calc.summary = TRUE, left = NULL, right = NULL, ...)
}
\arguments{
\item{formula}{Either a \code{glmertree} formula, looking like \code{dep ~ left | middle | right} where the \code{middle} part is an \code{lme4}-style random-effects specification, or an ordinary formula (or buildmer term list thereof) specifying only the dependent variable and \code{lme4}-style random effects. In the latter case, the additional arguments \code{left} and \code{right} must be specified as one-sided formulas containing the fixed part of the model and the partitioning part, respectively}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{cl}{See the general documentation under \code{\link{buildmer-package}}}

\item{direction}{See the general documentation under \code{\link{buildmer-package}}}

\item{crit}{See the general documentation under \code{\link{buildmer-package}}}

\item{include}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.summary}{See the general documentation under \code{\link{buildmer-package}}}

\item{left}{The left part of the \code{glmertree} formula, used if \code{formula} does not contain \code{glmertree}-specific terms. Note that if \code{left} is specified when \code{formula} is in \code{glmertree} format, \code{left} overrides the \code{formula} specification!}

\item{right}{The right part of the \code{glmertree} formula, used if \code{formula} does not contain \code{glmertree}-specific terms. Note that if \code{right} is specified when \code{formula} is in \code{glmertree} format, \code{right} overrides the \code{formula} specification!}

\item{...}{Additional options to be passed to \code{lmertree} or \code{glmertree}}
}
\description{
Use \code{buildmer} to perform stepwise elimination for \emph{the random-effects part} of \code{lmertree()} and \code{glmertree()} models from package \code{glmertree}
}
\examples{
library(buildmer)
m <- buildmertree(Reaction ~ 1 | (Days|Subject) | Days,crit='LL',direction='order',
                  data=lme4::sleepstudy,joint=FALSE)
m <- buildmertree(Reaction ~ 1 | (Days|Subject) | Days,crit='LL',direction='order',
                  data=lme4::sleepstudy,family=Gamma(link=identity),joint=FALSE)
}
\seealso{
\code{\link{buildmer-package}}
}
