% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_add_estimate_to_reference_rows.R
\name{tidy_add_estimate_to_reference_rows}
\alias{tidy_add_estimate_to_reference_rows}
\title{Add an estimate value to references rows for categorical variables}
\usage{
tidy_add_estimate_to_reference_rows(
  x,
  exponentiate = attr(x, "exponentiate"),
  conf.level = attr(x, "conf.level"),
  model = tidy_get_model(x),
  quiet = FALSE
)
}
\arguments{
\item{x}{(\code{data.frame})\cr
A tidy tibble as produced by \verb{tidy_*()} functions.}

\item{exponentiate}{(\code{logical})\cr
Whether or not to exponentiate the coefficient estimates. It should be
consistent with the original call to \code{\link[broom:reexports]{broom::tidy()}}}

\item{conf.level}{(\code{numeric})\cr
Confidence level, by default use the value indicated
previously in \code{\link[=tidy_and_attach]{tidy_and_attach()}}, used only for sum contrasts.}

\item{model}{(a model object, e.g. \code{glm})\cr
The corresponding model, if not attached to \code{x}.}

\item{quiet}{(\code{logical})\cr
Whether \code{broom.helpers} should not return a message when requested output
cannot be generated. Default is \code{FALSE}.}
}
\description{
For categorical variables with a treatment contrast
(\code{\link[stats:contrast]{stats::contr.treatment()}}) or a SAS contrast (\code{\link[stats:contrast]{stats::contr.SAS()}}),
will add an estimate equal to \code{0} (or \code{1} if \code{exponentiate = TRUE})
to the reference row.
}
\details{
For categorical variables with a sum contrast (\code{\link[stats:contrast]{stats::contr.sum()}}),
the estimate value of the reference row will be equal to the sum of
all other coefficients multiplied by \code{-1} (eventually exponentiated if
\code{exponentiate = TRUE}), and obtained with \code{emmeans::emmeans()}.
The \code{emmeans} package should therefore be installed.
For sum contrasts, the model coefficient corresponds
to the difference of each level with the grand mean.
For sum contrasts, confidence intervals and p-values will also
be computed and added to the reference rows.

For other variables, no change will be made.

If the \code{reference_row} column is not yet available in \code{x},
\code{\link[=tidy_add_reference_rows]{tidy_add_reference_rows()}} will be automatically applied.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (.assert_package("gtsummary", boolean = TRUE) && .assert_package("emmeans", boolean = TRUE)) {
  df <- Titanic |>
    dplyr::as_tibble() |>
    dplyr::mutate(dplyr::across(where(is.character), factor))

  glm(
    Survived ~ Class + Age + Sex,
    data = df, weights = df$n, family = binomial,
    contrasts = list(Age = contr.sum, Class = "contr.SAS")
  ) |>
    tidy_and_attach(exponentiate = TRUE) |>
    tidy_add_reference_rows() |>
    tidy_add_estimate_to_reference_rows()

  glm(
    response ~ stage + grade * trt,
    gtsummary::trial,
    family = binomial,
    contrasts = list(
      stage = contr.treatment(4, base = 3),
      grade = contr.treatment(3, base = 2),
      trt = contr.treatment(2, base = 2)
    )
  ) |>
    tidy_and_attach() |>
    tidy_add_reference_rows() |>
    tidy_add_estimate_to_reference_rows()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_pairwise_contrasts}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
