% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_validation_summaries}
\alias{get_validation_summaries}
\title{Obtains suitable validation summary statistics from MCMC samples 
 obtained for  validation.}
\usage{
get_validation_summaries(samps, level = 95)
}
\arguments{
\item{samps}{A matrix of N by p samples for the p parameters}

\item{level}{Desired confidence level - defaults to 95\%.}
}
\value{
A data frame containing five columns: meanpred, 
medianpred, sdpred, low (er limit), 
and up (per limit) for the p parameters.
}
\description{
Obtains suitable validation summary statistics from MCMC samples 
 obtained for  validation.
}
\examples{
set.seed(4)
vrows <- sample(nrow(nysptime), 100)
M1 <- Bsptime(model="lm", formula=y8hrmax~xmaxtemp+xwdsp+xrh, data=nysptime, 
validrows=vrows, scale.transform = "SQRT")
samps<- M1$valpreds
valsums <- get_validation_summaries(samps)
head(valsums)  
}
