% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_scale_fill.R
\name{bi_scale_fill}
\alias{bi_scale_fill}
\title{Apply Bivariate Scale to ggplot Object}
\usage{
bi_scale_fill(pal, dim = 3, ...)
}
\arguments{
\item{pal}{A palette name; one of \code{"Brown"}, \code{"DkBlue"},
\code{"DkCyan"}, \code{"DkViolet"}, or \code{"GrPink"}.}

\item{dim}{The dimensions of the palette, either \code{2} for a two-by-two palette or
\code{3} for a three-by-three palette.}

\item{...}{Arguments to pass to \code{\link{scale_fill_manual}}}
}
\value{
A \code{ggplot} object with the given bivariate palette applied to the data.
}
\description{
Applies the selected palette as the fill aesthetic when \code{\link{geom_sf}}
    is used and the \code{bi_class} variable is given as the \code{fill} in the aesthetic
    mapping.
}
\examples{
# load suggested dependencies
library(ggplot2)
library(sf)

# add breaks, 2x2
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, dim = 2)

# create map
ggplot() +
  geom_sf(data = data, aes(fill = bi_class), color = "white", size = 0.1, show.legend = FALSE) +
  bi_scale_fill(pal = "GrPink", dim = 2)

# add breaks, 3x3
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, dim = 3)

# create map
ggplot() +
  geom_sf(data = data, aes(fill = bi_class), color = "white", size = 0.1, show.legend = FALSE) +
  bi_scale_fill(pal = "GrPink", dim = 3)

}
